/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.ClientStructurePackLoader;
import com.ldtteam.structurize.storage.StructurePackMeta;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class NotifyClientAboutStructurePacksMessage
implements IMessage {
    final Map<String, Integer> serverStructurePacks = new HashMap<String, Integer>();

    public NotifyClientAboutStructurePacksMessage(FriendlyByteBuf buf) {
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.serverStructurePacks.put(buf.m_130136_(Short.MAX_VALUE), buf.readInt());
        }
    }

    public NotifyClientAboutStructurePacksMessage(Map<String, StructurePackMeta> clientStructurePacks) {
        for (StructurePackMeta pack : clientStructurePacks.values()) {
            if (pack.isImmutable()) continue;
            this.serverStructurePacks.put(pack.getName(), pack.getVersion());
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.serverStructurePacks.size());
        for (Map.Entry<String, Integer> packInfo : this.serverStructurePacks.entrySet()) {
            buf.m_130070_(packInfo.getKey());
            buf.writeInt(packInfo.getValue().intValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!isLogicalServer) {
            ClientStructurePackLoader.onServerSyncAttempt(this.serverStructurePacks);
        }
    }
}

