/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.controls.ToggleButton;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.client.gui.AbstractBlueprintManipulationWindow;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public class WindowShapeTool
extends AbstractBlueprintManipulationWindow {
    private static int width = 1;
    private static int height = 1;
    private static int length = 1;
    private static int frequency = 1;
    private static String equation = "";
    private static boolean hollow = false;
    private static Shape shape = Shape.CUBE;
    private static ItemStack mainBlock = new ItemStack((ItemLike)Blocks.f_50074_);
    private static ItemStack secondaryBlock = new ItemStack((ItemLike)Blocks.f_50074_);
    private static final String BUTTON_MINUS = "minus";
    private static final String BUTTON_PLUS = "plus";
    private final List<String> sections = new ArrayList<String>();
    private DropDownList sectionsDropDownList;
    private TextField inputWidth;
    private TextField inputLength;
    private TextField inputHeight;
    private TextField inputFrequency;
    private TextField inputShape;
    private int shapeWidth = 1;
    private int shapeLength = 1;
    private int shapeHeight = 1;
    private int shapeFrequency = 1;
    private String shapeequation = "";

    public WindowShapeTool(@Nullable BlockPos pos) {
        super("structurize:gui/windowshapetool.xml", pos, 0, "shapes");
        this.init(pos, false);
    }

    private void init(BlockPos pos, boolean shouldUpdate) {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData("shapes");
        @Nullable Blueprint structure = previewData.getBlueprint();
        if (structure != null) {
            this.shapeWidth = width;
            this.shapeLength = length;
            this.shapeHeight = height;
            this.shapeFrequency = frequency;
            this.shapeequation = equation;
        }
        this.registerButton("pickMainBlock", this::pickMainBlock);
        this.registerButton("pickFillBlock", this::pickFillBlock);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.registerButton("hollowShape", this::hollowShapeToggle);
        this.inputWidth = (TextField)this.findPaneOfTypeByID("width", TextField.class);
        this.inputLength = (TextField)this.findPaneOfTypeByID("length", TextField.class);
        this.inputHeight = (TextField)this.findPaneOfTypeByID("height", TextField.class);
        this.inputFrequency = (TextField)this.findPaneOfTypeByID("frequency", TextField.class);
        this.inputShape = (TextField)this.findPaneOfTypeByID("shape", TextField.class);
        this.inputWidth.setText(Integer.toString(width));
        this.inputLength.setText(Integer.toString(length));
        this.inputHeight.setText(Integer.toString(height));
        this.inputFrequency.setText(Integer.toString(frequency));
        this.inputShape.setText(equation);
        this.registerButton("widthminus", () -> this.adjust(this.inputWidth, width - 1));
        this.registerButton("widthplus", () -> this.adjust(this.inputWidth, width + 1));
        this.registerButton("lengthminus", () -> this.adjust(this.inputLength, length - 1));
        this.registerButton("lengthplus", () -> this.adjust(this.inputLength, length + 1));
        this.registerButton("heightminus", () -> this.adjust(this.inputHeight, height - 1));
        this.registerButton("heightplus", () -> this.adjust(this.inputHeight, height + 1));
        this.registerButton("frequencyminus", () -> this.adjust(this.inputFrequency, frequency - 1));
        this.registerButton("frequencyplus", () -> this.adjust(this.inputFrequency, frequency + 1));
        this.sections.clear();
        this.sections.addAll(Arrays.stream(Shape.values()).map(Enum::name).toList());
        this.sectionsDropDownList = (DropDownList)this.findPaneOfTypeByID("style", DropDownList.class);
        this.sectionsDropDownList.setHandler(this::onDropDownListChanged);
        this.sectionsDropDownList.setDataProvider((DropDownList.DataProvider)new SectionDropDownList());
        this.sectionsDropDownList.setSelectedIndex(shape.ordinal());
        this.registerButton("nextShape", () -> ((DropDownList)this.sectionsDropDownList).selectNext());
        this.registerButton("previousShape", () -> ((DropDownList)this.sectionsDropDownList).selectPrevious());
        this.disableInputIfNecessary();
        if (structure == null || shouldUpdate) {
            WindowShapeTool.genShape();
        }
        this.updateRotationState();
        ((ToggleButton)this.findPaneOfTypeByID("hollowShape", ToggleButton.class)).setActiveState(hollow ? "hollow" : "solid");
    }

    private static void genShape() {
        RenderingCache.getOrCreateBlueprintPreviewData("shapes").setBlueprint(Manager.getStructureFromFormula(width, length, height, frequency, equation, shape, mainBlock, secondaryBlock, hollow));
    }

    private void disableInputIfNecessary() {
        View height = (View)this.findPaneOfTypeByID("heightInput", View.class);
        View width = (View)this.findPaneOfTypeByID("widthInput", View.class);
        View length = (View)this.findPaneOfTypeByID("lengthInput", View.class);
        View frequency = (View)this.findPaneOfTypeByID("frequencyInput", View.class);
        View equation = (View)this.findPaneOfTypeByID("shapeInput", View.class);
        height.show();
        width.show();
        length.show();
        frequency.show();
        equation.hide();
        this.findPaneByID("hollowShape").show();
        this.findPaneByID("pickFillBlock").show();
        this.findPaneByID("resourceIconFill").show();
        if (shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL || shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
            width.hide();
            length.hide();
            frequency.hide();
        } else if (shape == Shape.CYLINDER || shape == Shape.CONE) {
            length.hide();
            frequency.hide();
        } else if (shape != Shape.WAVE && shape != Shape.WAVE_3D) {
            frequency.hide();
        }
    }

    private void pickMainBlock() {
        new WindowReplaceBlock(mainBlock, RenderingCache.getOrCreateBlueprintPreviewData("shapes").getPos(), true, (BOWindow)this).open();
    }

    private void pickFillBlock() {
        new WindowReplaceBlock(secondaryBlock, RenderingCache.getOrCreateBlueprintPreviewData("shapes").getPos(), false, (BOWindow)this).open();
    }

    private void adjust(TextField input, int value) {
        input.setText(Integer.toString(Math.max(1, value)));
        this.onKeyTyped('\u0000', 0);
    }

    private void hollowShapeToggle() {
        ToggleButton hollowButton = (ToggleButton)this.findPaneOfTypeByID("hollowShape", ToggleButton.class);
        hollow = hollowButton.isActiveState("hollow");
        WindowShapeTool.genShape();
    }

    @Override
    protected void handlePlacement(BuildToolPlacementMessage.HandlerType type, String id) {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData("shapes");
        if (previewData.getBlueprint() != null) {
            String packName = Minecraft.m_91087_().m_91094_().m_92546_();
            Path subpath = Path.of("shapes", shape.toString().toLowerCase(Locale.ROOT), mainBlock.m_41720_().toString().replace(':', '_'), secondaryBlock.m_41720_().toString().replace(':', '_'), String.format("%dx%dx%dx%d_%c.blueprint", length, width, height, frequency, Character.valueOf(hollow ? (char)'h' : 'f')));
            Path path = Minecraft.m_91087_().f_91069_.toPath().resolve("blueprints").resolve(packName.toLowerCase(Locale.US)).resolve(subpath);
            CompoundTag compound = BlueprintUtil.writeBlueprintToNBT(previewData.getBlueprint());
            ClientFutureProcessor.queueBlueprint(new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.storeBlueprint(packName, compound, path), blueprint -> Network.getNetwork().sendToServer(new BuildToolPlacementMessage(type, id, packName, subpath.toString(), previewData.getPos(), Rotation.NONE, Mirror.NONE))));
            if (type == BuildToolPlacementMessage.HandlerType.Survival) {
                this.clearAndClose();
            }
        }
    }

    @Override
    protected void cancelClicked() {
        width = 1;
        height = 1;
        length = 1;
        frequency = 1;
        equation = "";
        hollow = false;
        shape = Shape.CUBE;
        mainBlock = new ItemStack((ItemLike)Blocks.f_50074_);
        secondaryBlock = new ItemStack((ItemLike)Blocks.f_50074_);
        this.clearAndClose();
    }

    private void clearAndClose() {
        RenderingCache.removeBlueprint("shapes");
        this.close();
    }

    @Override
    public void onOpened() {
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconMain", ItemIcon.class)).setItem(mainBlock);
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconFill", ItemIcon.class)).setItem(secondaryBlock);
        ((Button)this.findPaneOfTypeByID("undoredo", Button.class)).setVisible(this.isCreative());
        super.onOpened();
    }

    public void updateBlock(ItemStack stack, boolean isMain) {
        if (isMain) {
            mainBlock = stack;
        } else {
            secondaryBlock = stack;
        }
        ((ItemIcon)this.findPaneOfTypeByID(isMain ? "resourceIconMain" : "resourceIconFill", ItemIcon.class)).setItem(stack);
        WindowShapeTool.genShape();
    }

    public boolean isCreative() {
        return Minecraft.m_91087_().f_91074_.m_7500_();
    }

    private void onDropDownListChanged(DropDownList list) {
        if (list == this.sectionsDropDownList) {
            this.updateStyle(this.sections.get(this.sectionsDropDownList.getSelectedIndex()));
        }
    }

    private void updateStyle(String s) {
        if (Shape.valueOf(this.sections.get(this.sectionsDropDownList.getSelectedIndex())) != shape) {
            shape = Shape.valueOf(s);
            WindowShapeTool.genShape();
        }
        this.disableInputIfNecessary();
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String widthText = this.inputWidth.getText();
        String lengthText = this.inputLength.getText();
        String heightText = this.inputHeight.getText();
        String frequencyText = this.inputFrequency.getText();
        String localequation = this.inputShape.getText();
        if (!(widthText.isEmpty() || lengthText.isEmpty() || heightText.isEmpty())) {
            try {
                int localWidth = Integer.parseInt(widthText);
                int localHeight = Integer.parseInt(heightText);
                int localLength = Integer.parseInt(lengthText);
                int localFrequency = Integer.parseInt(frequencyText);
                if (this.shapeHeight != localHeight || this.shapeLength != localLength || this.shapeWidth != localWidth || this.shapeFrequency != localFrequency || !this.shapeequation.equals(localequation)) {
                    this.shapeWidth = localWidth;
                    this.shapeLength = localLength;
                    this.shapeHeight = localHeight;
                    this.shapeFrequency = localFrequency;
                    this.shapeequation = localequation;
                    width = localWidth;
                    length = localLength;
                    height = localHeight;
                    frequency = localFrequency;
                    equation = localequation;
                    WindowShapeTool.genShape();
                }
            }
            catch (NumberFormatException e) {
                this.inputWidth.setText(Integer.toString(width));
                this.inputLength.setText(Integer.toString(length));
                this.inputHeight.setText(Integer.toString(height));
            }
        }
        return result;
    }

    private class SectionDropDownList
    implements DropDownList.DataProvider {
        private SectionDropDownList() {
        }

        public int getElementCount() {
            return WindowShapeTool.this.sections.size();
        }

        public String getLabel(int index) {
            return WindowShapeTool.this.sections.get(index);
        }
    }
}

