/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.google.gson.internal.LazilyParsedNumber;
import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ImageRepeatable;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.controls.TextFieldVanilla;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.ModKeyMappings;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.SurvivalBlueprintHandlers;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlueprintManipulationWindow
extends AbstractWindowSkeleton {
    private final String bluePrintId;
    protected ScrollingList settingsList;
    private final ScrollingList placementOptionsList;
    protected int groundstyle;
    private int openTicks = 0;

    public AbstractBlueprintManipulationWindow(@NotNull String resourceId, @Nullable BlockPos pos, int groundstyle, String blueprintId) {
        super(resourceId);
        this.groundstyle = groundstyle;
        this.bluePrintId = blueprintId;
        if (pos != null && RenderingCache.getOrCreateBlueprintPreviewData(blueprintId).getPos() == null) {
            RenderingCache.getOrCreateBlueprintPreviewData(blueprintId).setPos(pos);
            this.adjustToGroundOffset();
        }
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", this::mirrorClicked);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", this::moveUpClicked);
        this.registerButton("minus", this::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton("settings", this::settingsClicked);
        this.settingsList = (ScrollingList)this.findPaneOfTypeByID("settinglist", ScrollingList.class);
        this.placementOptionsList = (ScrollingList)this.findPaneOfTypeByID("placement", ScrollingList.class);
        this.updateRotationState();
        ((Text)this.findPaneOfTypeByID("tip", Text.class)).setVisible(pos != null);
        this.initSettings();
    }

    public void onOpened() {
        super.onOpened();
        if (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getPos() == null) {
            Utils.playErrorSound((Player)Minecraft.m_91087_().f_91074_);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"structurize.gui.missing.pos"), false);
            this.cancelClicked();
        }
    }

    protected abstract void cancelClicked();

    protected void confirmClicked() {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId);
        if (previewData.getBlueprint() != null) {
            if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                List<ISurvivalBlueprintHandler> handlers = SurvivalBlueprintHandlers.getMatchingHandlers(previewData.getBlueprint(), Minecraft.m_91087_().f_91073_, (Player)Minecraft.m_91087_().f_91074_, previewData.getPos(), previewData.getPlacementSettings());
                if (handlers.isEmpty()) {
                    Utils.playErrorSound((Player)Minecraft.m_91087_().f_91074_);
                    if (SurvivalBlueprintHandlers.getHandlers().isEmpty()) {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"structurize.gui.no.survival.handler"), false);
                    }
                    return;
                }
                if (handlers.size() == 1) {
                    this.handlePlacement(BuildToolPlacementMessage.HandlerType.Survival, handlers.get(0).getId());
                    return;
                }
            }
            this.updatePlacementOptions();
        }
    }

    protected abstract void handlePlacement(BuildToolPlacementMessage.HandlerType var1, String var2);

    protected void hideOtherGuiForPlacement() {
        this.settingsList.hide();
        this.settingsList.disable();
    }

    protected void hidePlacementGui() {
        this.placementOptionsList.hide();
        this.placementOptionsList.disable();
        this.settingsList.hide();
        this.settingsList.disable();
    }

    public void updatePlacementOptions() {
        BlueprintPreviewData previewData;
        this.placementOptionsList.enable();
        this.placementOptionsList.show();
        this.hideOtherGuiForPlacement();
        final ArrayList<Tuple> categories = new ArrayList<Tuple>();
        if (Minecraft.m_91087_().f_91074_.m_7500_()) {
            categories.add(new Tuple((Object)Component.m_237115_((String)"structurize.gui.buildtool.complete"), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Complete, "")));
            categories.add(new Tuple((Object)Component.m_237115_((String)"structurize.gui.buildtool.pretty"), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Pretty, "")));
        }
        if ((previewData = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId)).getBlueprint() != null) {
            for (ISurvivalBlueprintHandler handler : SurvivalBlueprintHandlers.getMatchingHandlers(previewData.getBlueprint(), Minecraft.m_91087_().f_91073_, (Player)Minecraft.m_91087_().f_91074_, previewData.getPos(), previewData.getPlacementSettings())) {
                categories.add(new Tuple((Object)handler.getDisplayName(), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Survival, handler.getId())));
            }
        }
        this.placementOptionsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return categories.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ButtonImage buttonImage = (ButtonImage)rowPane.findPaneOfTypeByID("type", ButtonImage.class);
                buttonImage.setText((Component)((Tuple)categories.get(index)).m_14418_());
                buttonImage.setTextColor(ChatFormatting.BLACK.m_126665_().intValue());
                buttonImage.setHandler(button -> ((Runnable)((Tuple)categories.get(index)).m_14419_()).run());
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.openTicks++ >= 200) {
            ((Text)this.findPaneOfTypeByID("tip", Text.class)).setVisible(false);
        }
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (ch != 0 || AbstractBlueprintManipulationWindow.getFocus() != null) {
            return super.onUnhandledKeyTyped(ch, key);
        }
        InputConstants.Key inputKey = InputConstants.Type.KEYSYM.m_84895_(key);
        if (((KeyMapping)ModKeyMappings.MOVE_FORWARD.get()).isActiveAndMatches(inputKey)) {
            this.moveForwardClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_BACK.get()).isActiveAndMatches(inputKey)) {
            this.moveBackClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_LEFT.get()).isActiveAndMatches(inputKey)) {
            this.moveLeftClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_RIGHT.get()).isActiveAndMatches(inputKey)) {
            this.moveRightClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_UP.get()).isActiveAndMatches(inputKey)) {
            this.moveUpClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_DOWN.get()).isActiveAndMatches(inputKey)) {
            this.moveDownClicked();
        } else if (((KeyMapping)ModKeyMappings.ROTATE_CW.get()).isActiveAndMatches(inputKey)) {
            this.rotateRightClicked();
        } else if (((KeyMapping)ModKeyMappings.ROTATE_CCW.get()).isActiveAndMatches(inputKey)) {
            this.rotateLeftClicked();
        } else if (((KeyMapping)ModKeyMappings.MIRROR.get()).isActiveAndMatches(inputKey)) {
            this.mirrorClicked();
        } else if (((KeyMapping)ModKeyMappings.PLACE.get()).isActiveAndMatches(inputKey)) {
            this.confirmClicked();
        } else {
            return super.onUnhandledKeyTyped(ch, key);
        }
        return true;
    }

    protected void settingsClicked() {
        if (this.settingsList.isVisible()) {
            this.settingsList.hide();
            this.settingsList.disable();
            return;
        }
        this.settingsList.show();
        this.settingsList.enable();
    }

    protected void initSettings() {
        ArrayList settings = new ArrayList();
        Structurize.getConfig().getClient().collectPreviewRendererSettings(settings::add);
        this.settingsList.setDataProvider(settings::size, (index, rowPane) -> {
            TranslatableContents tkey;
            ComponentContents patt13284$temp;
            ForgeConfigSpec.ConfigValue setting = (ForgeConfigSpec.ConfigValue)settings.get(index);
            Optional<ForgeConfigSpec.ValueSpec> optional = Structurize.getConfig().getSpecFromValue(setting);
            Text label = (Text)rowPane.findPaneOfTypeByID("label", Text.class);
            if (optional.isEmpty()) {
                label.setText(Component.m_237115_((String)"structurize.gui.settings.novaluespec"));
                return;
            }
            ForgeConfigSpec.ValueSpec settingSpec = optional.get();
            String nameTKey = settingSpec.getTranslationKey();
            if (label.getText() != null && (patt13284$temp = label.getText().m_214077_()) instanceof TranslatableContents && (tkey = (TranslatableContents)patt13284$temp).m_237508_().equals(nameTKey)) {
                return;
            }
            label.setText(Component.m_237115_((String)nameTKey));
            PaneBuilders.singleLineTooltip((MutableComponent)Component.m_237115_((String)(nameTKey + ".comment")), (Pane)rowPane);
            ButtonImage buttonImage = (ButtonImage)rowPane.findPaneOfTypeByID("switch", ButtonImage.class);
            TextFieldVanilla inputField = (TextFieldVanilla)rowPane.findPaneOfTypeByID("set_input", TextFieldVanilla.class);
            Object patt13932$temp = setting.get();
            if (patt13932$temp instanceof Boolean) {
                Boolean value = (Boolean)patt13932$temp;
                typedSetting = setting;
                inputField.off();
                buttonImage.on();
                buttonImage.setText(Component.m_237115_((String)(value != false ? "options.on" : "options.off")));
                buttonImage.setHandler(button -> {
                    Boolean newValue = (Boolean)typedSetting.get() == false;
                    Structurize.getConfig().set(typedSetting, newValue);
                    buttonImage.setText(Component.m_237115_((String)(newValue != false ? "options.on" : "options.off")));
                });
            } else {
                Object patt14604$temp = setting.get();
                if (patt14604$temp instanceof Number) {
                    Number value = (Number)patt14604$temp;
                    typedSetting = setting;
                    buttonImage.off();
                    inputField.on();
                    inputField.setText(((Number)typedSetting.get()).toString());
                    inputField.setFilter(new TextField.Filter(){

                        public String filter(String s) {
                            return s;
                        }

                        public boolean isAllowedCharacter(char c) {
                            return Character.isDigit(c) || c == '-' || c == '.';
                        }
                    });
                    inputField.setHandler(a -> {
                        boolean testResult;
                        if (inputField.getText().isBlank()) {
                            return;
                        }
                        LazilyParsedNumber newValue = new LazilyParsedNumber(inputField.getText());
                        try {
                            testResult = settingSpec.test((Object)newValue);
                        }
                        catch (NumberFormatException e) {
                            inputField.setTextColor(-65536);
                            return;
                        }
                        if (testResult) {
                            inputField.setTextColor(-2039584);
                            ForgeConfigSpec.DoubleValue rendererTransparency = Structurize.getConfig().getClient().rendererTransparency;
                            if (setting == rendererTransparency && (Double)rendererTransparency.get() < 0.0) {
                                View confirmDialog = new View();
                                confirmDialog.setPosition(70, 0);
                                confirmDialog.setSize(177, 150);
                                confirmDialog.setAlignment(Alignment.MIDDLE);
                                Gradient hidingLayer = new Gradient();
                                hidingLayer.setGradientStart(16, 16, 16, 192);
                                hidingLayer.setGradientEnd(16, 16, 16, 208);
                                hidingLayer.setSize(this.getWindow().getWidth(), this.getWindow().getHeight());
                                this.getWindow().addChild((Pane)hidingLayer);
                                this.getWindow().addChild((Pane)confirmDialog);
                                View.setFocus(null);
                                ImageRepeatable background = new ImageRepeatable();
                                background.setSize(177, 150);
                                background.setImageLoc(new ResourceLocation("structurize", "textures/gui/builderhut/builder_papper.png"));
                                background.setImageSize(6, 7, 177, 231, 20, 20, 100, 100);
                                confirmDialog.addChild((Pane)background);
                                Text text = new Text();
                                text.setPosition(10, 8);
                                text.setSize(157, 105);
                                text.setColors(Color.getByName((String)"black").intValue());
                                text.setTextAlignment(Alignment.TOP_MIDDLE);
                                text.setText(Component.m_237115_((String)"structurize.config.transparency.warning"));
                                confirmDialog.addChild((Pane)text);
                                ButtonImage confirm = new ButtonImage();
                                confirm.setPosition(10, 123);
                                confirm.setSize(64, 17);
                                confirm.setImage(new ResourceLocation("structurize", "textures/gui/builderhut/builder_button_small.png"), false);
                                confirm.setColors(Color.getByName((String)"black").intValue());
                                confirm.setTextAlignment(Alignment.MIDDLE);
                                confirm.setTextRenderBox(64, 17);
                                confirm.setText(Component.m_237115_((String)"gui.yes"));
                                confirm.setHandler(arg_0 -> this.lambda$initSettings$4((Number)newValue, rendererTransparency, inputField, hidingLayer, confirmDialog, arg_0));
                                confirmDialog.addChild((Pane)confirm);
                                ButtonImage cancel = new ButtonImage();
                                cancel.setPosition(103, 123);
                                cancel.setSize(64, 17);
                                cancel.setImage(new ResourceLocation("structurize", "textures/gui/builderhut/builder_button_small.png"), false);
                                cancel.setColors(Color.getByName((String)"black").intValue());
                                cancel.setTextAlignment(Alignment.MIDDLE);
                                cancel.setTextRenderBox(64, 17);
                                cancel.setText(Component.m_237115_((String)"gui.cancel"));
                                cancel.setHandler(b -> {
                                    inputField.setText(Double.toString((Double)rendererTransparency.get()));
                                    this.getWindow().removeChild((Pane)hidingLayer);
                                    this.getWindow().removeChild((Pane)confirmDialog);
                                });
                                confirmDialog.addChild((Pane)cancel);
                            } else {
                                Object oldValue = typedSetting.get();
                                if (oldValue instanceof Integer) {
                                    Structurize.getConfig().set(typedSetting, newValue.intValue());
                                } else if (oldValue instanceof Long) {
                                    Structurize.getConfig().set(typedSetting, newValue.longValue());
                                } else if (oldValue instanceof Double) {
                                    Structurize.getConfig().set(typedSetting, newValue.doubleValue());
                                }
                            }
                        } else {
                            inputField.setTextColor(-65536);
                        }
                    });
                }
            }
        });
    }

    private void mirrorClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).mirror();
        this.updateRotationState();
    }

    private void moveUpClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 1, 0));
    }

    private void moveDownClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_().m_122428_()));
    }

    private void moveRightClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_().m_122427_()));
    }

    private void moveForwardClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_()));
    }

    private void moveBackClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_().m_122424_()));
    }

    private void rotateRightClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).rotate(Rotation.CLOCKWISE_90);
        this.updateRotationState();
    }

    private void rotateLeftClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).rotate(Rotation.COUNTERCLOCKWISE_90);
        this.updateRotationState();
    }

    protected void updateRotationState() {
        ((ButtonImage)this.findPaneOfTypeByID("mirror", ButtonImage.class)).setImage(new ResourceLocation("structurize", String.format("textures/gui/buildtool/%s.png", "mirror" + (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getRotationMirror().mirror().equals((Object)Mirror.NONE) ? "" : "_green"))), false);
        String rotation = switch (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getRotationMirror().rotation()) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.CLOCKWISE_90 -> "right_green";
            case Rotation.CLOCKWISE_180 -> "down_green";
            case Rotation.COUNTERCLOCKWISE_90 -> "left_green";
            case Rotation.NONE -> "up_green";
        };
        ((Image)this.findPaneOfTypeByID("rotation", Image.class)).setImage(new ResourceLocation("structurize", String.format("textures/gui/buildtool/%s.png", rotation)), false);
    }

    protected void adjustToGroundOffset() {
        Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getBlueprint();
        if (blueprint != null) {
            RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).setGroundOffset(--groundOffset);
        }
    }

    private /* synthetic */ void lambda$initSettings$4(Number newValue, ForgeConfigSpec.DoubleValue rendererTransparency, TextFieldVanilla inputField, Gradient hidingLayer, View confirmDialog, Button b) {
        double newVal = newValue.doubleValue();
        Structurize.getConfig().set(rendererTransparency, newVal < 0.0 ? 1.0 : newVal);
        if (newVal < 0.0) {
            inputField.setText("1.0");
        }
        this.getWindow().removeChild((Pane)hidingLayer);
        this.getWindow().removeChild((Pane)confirmDialog);
    }
}

