/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.TickedWorldOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ReplaceBlockMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final ItemStack blockFrom;
    private final ItemStack blockTo;
    private final int pct;

    public ReplaceBlockMessage(FriendlyByteBuf buf) {
        this.from = buf.m_130135_();
        this.to = buf.m_130135_();
        this.blockTo = buf.m_130267_();
        this.blockFrom = buf.m_130267_();
        this.pct = buf.readInt();
    }

    public ReplaceBlockMessage(BlockPos pos1, BlockPos pos2, ItemStack blockFrom, ItemStack blockTo, int pct) {
        this.from = pos1;
        this.to = pos2;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.pct = pct;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.from);
        buf.m_130064_(this.to);
        buf.m_130055_(this.blockTo);
        buf.m_130055_(this.blockFrom);
        buf.writeInt(this.pct);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        Manager.addToQueue(new TickedWorldOperation(TickedWorldOperation.OperationType.REPLACE_BLOCK, this.from, this.to, (Player)ctxIn.getSender(), this.blockFrom, this.blockTo, this.pct));
    }
}

