/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class BarrelMaterialRecipe
extends CustomRecipe {
    public BarrelMaterialRecipe(ResourceLocation registryName) {
        super(registryName);
    }

    public boolean matches(CraftingContainer container, Level level) {
        int barrelRow = -1;
        int barrelCol = -1;
        int minRowWithBlock = Integer.MAX_VALUE;
        int minColWithBlock = Integer.MAX_VALUE;
        int maxRowWithBlock = Integer.MIN_VALUE;
        int maxColWithBlock = Integer.MIN_VALUE;
        HashMap<Integer, Integer> rowCounts = new HashMap<Integer, Integer>();
        for (int row = 0; row < container.m_39346_(); ++row) {
            for (int col = 0; col < container.m_39347_(); ++col) {
                BlockItem blockItem;
                ItemStack item = container.m_8020_(col + row * container.m_39347_());
                if (item.m_41619_()) continue;
                Item item2 = item.m_41720_();
                if (item2 instanceof BlockItem && (blockItem = (BlockItem)item2).m_40614_() instanceof BarrelBlock) {
                    if (barrelRow < 0) {
                        barrelRow = row;
                        barrelCol = col;
                        continue;
                    }
                    return false;
                }
                if (item.m_41720_() instanceof BlockItem) {
                    boolean isBottomMiddleAndBottomLeftHasBlock;
                    boolean bl = isBottomMiddleAndBottomLeftHasBlock = barrelCol == col && barrelRow < row && rowCounts.getOrDefault(row, 0) > 0;
                    if (isBottomMiddleAndBottomLeftHasBlock) {
                        return false;
                    }
                    rowCounts.compute(row, (k, v) -> v == null ? 1 : v + 1);
                    if (row < minRowWithBlock) {
                        minRowWithBlock = row;
                    }
                    if (col < minColWithBlock) {
                        minColWithBlock = col;
                    }
                    if (row > maxRowWithBlock) {
                        maxRowWithBlock = row;
                    }
                    if (col <= maxColWithBlock) continue;
                    maxColWithBlock = col;
                    continue;
                }
                return false;
            }
        }
        if (barrelRow < 0 || rowCounts.isEmpty() || minRowWithBlock < barrelRow - 1 || maxRowWithBlock > barrelRow + 1 || minColWithBlock < barrelCol - 1 || maxColWithBlock > barrelCol + 1) {
            return false;
        }
        return rowCounts.getOrDefault(barrelRow - 1, 0) <= 3 && rowCounts.getOrDefault(barrelRow, 0) <= 2 && rowCounts.getOrDefault(barrelRow + 1, 0) <= 2;
    }

    public ItemStack assemble(CraftingContainer container) {
        int barrelColumn = -1;
        int barrelRow = -1;
        ItemStack barrelStackCopy = ItemStack.f_41583_;
        for (int row = 0; row < container.m_39346_(); ++row) {
            for (int col = 0; col < container.m_39347_(); ++col) {
                BlockItem blockItem;
                Item item;
                ItemStack item2 = container.m_8020_(col + row * container.m_39347_());
                if (item2.m_41619_() || barrelColumn >= 0 || !((item = item2.m_41720_()) instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof BarrelBlock)) continue;
                barrelColumn = col;
                barrelRow = row;
                barrelStackCopy = item2.m_41777_();
                barrelStackCopy.m_41764_(1);
            }
        }
        EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(barrelStackCopy));
        this.uncompactMaterials(materials);
        this.fillGridMaterials(container, barrelColumn, barrelRow, materials);
        BarrelMaterialRecipe.fillEmptyMaterialsWithDefaults(materials);
        BarrelMaterialRecipe.compactMaterials(materials);
        BarrelBlockItem.setMaterials(barrelStackCopy, materials);
        BarrelMaterialRecipe.removeCoveredTints(barrelStackCopy, materials);
        return barrelStackCopy;
    }

    private void uncompactMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        if (materials.isEmpty()) {
            return;
        }
        EnumMap uncompactedMaterials = new EnumMap(BarrelMaterial.class);
        materials.forEach((mat, texture) -> {
            for (BarrelMaterial child : mat.getChildren()) {
                uncompactedMaterials.put(child, texture);
            }
        });
        materials.clear();
        materials.putAll(uncompactedMaterials);
    }

    private static void removeCoveredTints(ItemStack barrelStackCopy, Map<BarrelMaterial, ResourceLocation> materials) {
        Item item = barrelStackCopy.m_41720_();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            boolean hasMainTint = tintableBlockItem.getMainColor(barrelStackCopy).isPresent();
            boolean hasAccentTint = tintableBlockItem.getAccentColor(barrelStackCopy).isPresent();
            if (hasMainTint || hasAccentTint) {
                Set materialModelParts = materials.keySet().stream().map(BarrelMaterial::getMaterialModelPart).collect(Collectors.toSet());
                if (hasMainTint && (materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.BOTH) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE))) {
                    tintableBlockItem.removeMainColor(barrelStackCopy);
                }
                if (hasAccentTint && (materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.BOTH) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM))) {
                    tintableBlockItem.removeAccentColor(barrelStackCopy);
                }
            }
        }
    }

    private static void compactMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        for (BarrelMaterial material : BarrelMaterial.values()) {
            if (material.isLeaf()) continue;
            ResourceLocation firstChildTexture = null;
            boolean allChildrenHaveSameTexture = true;
            for (BarrelMaterial child : material.getChildren()) {
                ResourceLocation texture = materials.get((Object)child);
                if (texture == null || firstChildTexture != null && !firstChildTexture.equals((Object)texture)) {
                    allChildrenHaveSameTexture = false;
                    break;
                }
                if (firstChildTexture != null) continue;
                firstChildTexture = texture;
            }
            if (firstChildTexture == null || !allChildrenHaveSameTexture) continue;
            materials.put(material, firstChildTexture);
            for (BarrelMaterial child : material.getChildren()) {
                materials.remove((Object)child);
            }
        }
    }

    private static void fillEmptyMaterialsWithDefaults(Map<BarrelMaterial, ResourceLocation> materials) {
        block0: for (BarrelMaterial material : BarrelMaterial.values()) {
            if (!material.isLeaf() || materials.containsKey((Object)material)) continue;
            for (BarrelMaterial fillFromDefault : BarrelMaterial.getFillFromDefaults(material)) {
                if (!materials.containsKey((Object)fillFromDefault)) continue;
                materials.put(material, materials.get((Object)fillFromDefault));
                continue block0;
            }
        }
    }

    private void fillGridMaterials(CraftingContainer container, int barrelColumn, int barrelRow, Map<BarrelMaterial, ResourceLocation> materials) {
        for (int row = 0; row < container.m_39346_(); ++row) {
            for (int col = 0; col < container.m_39347_(); ++col) {
                Item item;
                ItemStack item2 = container.m_8020_(col + row * container.m_39347_());
                if (row == barrelRow && col == barrelColumn || item2.m_41619_() || !((item = item2.m_41720_()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                List<BarrelMaterial> barrelMaterials = this.getBarrelMaterials(row, col, barrelRow, barrelColumn);
                boolean firstMaterial = true;
                for (BarrelMaterial barrelMaterial : barrelMaterials) {
                    if (!materials.containsKey((Object)barrelMaterial) || firstMaterial) {
                        materials.put(barrelMaterial, ForgeRegistries.BLOCKS.getKey((Object)blockItem.m_40614_()));
                    }
                    firstMaterial = false;
                }
            }
        }
    }

    private List<BarrelMaterial> getBarrelMaterials(int row, int col, int barrelRow, int barrelColumn) {
        if (row < barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.TOP);
            }
            if (col == barrelColumn) {
                return List.of(BarrelMaterial.TOP_INNER_TRIM, BarrelMaterial.TOP, BarrelMaterial.TOP_TRIM);
            }
            return List.of(BarrelMaterial.TOP_TRIM);
        }
        if (row == barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.SIDE);
            }
            return List.of(BarrelMaterial.SIDE_TRIM);
        }
        if (col < barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM);
        }
        if (col == barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM, BarrelMaterial.BOTTOM_TRIM);
        }
        return List.of(BarrelMaterial.BOTTOM_TRIM);
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModBlocks.BARREL_MATERIAL_RECIPE_SERIALIZER.get();
    }
}

