/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ControllerBlockEntity
extends ControllerBlockEntityBase
implements ILockable,
ICountDisplay,
ITierDisplay,
IUpgradeDisplay {
    private long lastDepositTime = -100L;

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.CONTROLLER_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(15.0);
    }

    public void depositPlayerItems(Player player, InteractionHand hand) {
        if (this.m_58904_() == null) {
            return;
        }
        long gameTime = this.m_58904_().m_46467_();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        if (doubleClick) {
            player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(playerInventory -> InventoryHelper.iterate((IItemHandler)playerInventory, (slot, stack) -> {
                if (this.canDepositStack((ItemStack)stack)) {
                    ItemStack resultStack = this.insertItem((ItemStack)stack, true, false);
                    int countToExtract = stack.m_41613_() - resultStack.m_41613_();
                    if (countToExtract > 0 && playerInventory.extractItem(slot.intValue(), countToExtract, true).m_41613_() == countToExtract) {
                        this.insertItem(playerInventory.extractItem(slot.intValue(), countToExtract, false), false, false);
                    }
                }
            }));
            return;
        }
        ItemStack itemInHand = player.m_21120_(hand);
        if (!itemInHand.m_41619_() && this.canDepositStack(itemInHand)) {
            player.m_21008_(hand, this.insertItem(itemInHand, false, false));
        }
    }

    private boolean canDepositStack(ItemStack stack) {
        return this.hasItem(stack.m_41720_()) || this.isMemorizedItem(stack) || this.isFilterItem(stack.m_41720_());
    }

    @Override
    public void toggleLock() {
        HashSet unlockedStorages = new HashSet();
        HashSet lockedStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ILockable.class).ifPresent(lockable -> {
            if (lockable.isLocked()) {
                lockedStorages.add(lockable);
            } else {
                unlockedStorages.add(lockable);
            }
        }));
        if (unlockedStorages.isEmpty()) {
            lockedStorages.forEach(ILockable::toggleLock);
        } else {
            unlockedStorages.forEach(ILockable::toggleLock);
        }
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean shouldShowLock() {
        return false;
    }

    @Override
    public void toggleLockVisibility() {
        HashSet invisibleLockStorages = new HashSet();
        HashSet visibleLockStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ILockable.class).ifPresent(lockable -> {
            if (lockable.isLocked()) {
                if (lockable.shouldShowLock()) {
                    visibleLockStorages.add(lockable);
                } else {
                    invisibleLockStorages.add(lockable);
                }
            }
        }));
        if (invisibleLockStorages.isEmpty()) {
            visibleLockStorages.forEach(ILockable::toggleLockVisibility);
        } else {
            invisibleLockStorages.forEach(ILockable::toggleLockVisibility);
        }
    }

    @Override
    public boolean shouldShowCounts() {
        return false;
    }

    @Override
    public void toggleCountVisibility() {
        HashSet invisibleCountStorages = new HashSet();
        HashSet visibleCountStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ICountDisplay.class).ifPresent(countDisplay -> {
            if (countDisplay.shouldShowCounts()) {
                visibleCountStorages.add(countDisplay);
            } else {
                invisibleCountStorages.add(countDisplay);
            }
        }));
        if (invisibleCountStorages.isEmpty()) {
            visibleCountStorages.forEach(ICountDisplay::toggleCountVisibility);
        } else {
            invisibleCountStorages.forEach(ICountDisplay::toggleCountVisibility);
        }
    }

    @Override
    public List<Integer> getSlotCounts() {
        return List.of();
    }

    @Override
    public boolean shouldShowTier() {
        return false;
    }

    @Override
    public void toggleTierVisiblity() {
        HashSet invisibleTierStorages = new HashSet();
        HashSet visibleTierStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ITierDisplay.class).ifPresent(tierDisplay -> {
            if (tierDisplay.shouldShowTier()) {
                visibleTierStorages.add(tierDisplay);
            } else {
                invisibleTierStorages.add(tierDisplay);
            }
        }));
        if (invisibleTierStorages.isEmpty()) {
            visibleTierStorages.forEach(ITierDisplay::toggleTierVisiblity);
        } else {
            invisibleTierStorages.forEach(ITierDisplay::toggleTierVisiblity);
        }
    }

    @Override
    public boolean shouldShowUpgrades() {
        return false;
    }

    @Override
    public void toggleUpgradesVisiblity() {
        HashSet invisibleUpgradeStorages = new HashSet();
        HashSet visibleUpgradeStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, IUpgradeDisplay.class).ifPresent(upgradeDisplay -> {
            if (upgradeDisplay.shouldShowUpgrades()) {
                visibleUpgradeStorages.add(upgradeDisplay);
            } else {
                invisibleUpgradeStorages.add(upgradeDisplay);
            }
        }));
        if (invisibleUpgradeStorages.isEmpty()) {
            visibleUpgradeStorages.forEach(IUpgradeDisplay::toggleUpgradesVisiblity);
        } else {
            invisibleUpgradeStorages.forEach(IUpgradeDisplay::toggleUpgradesVisiblity);
        }
    }
}

