/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import org.apache.commons.lang3.function.TriFunction;

public interface IInventoryPartHandler {
    public static final IInventoryPartHandler EMPTY = () -> "EMPTY";

    default public int getSlotLimit(int slot) {
        return 0;
    }

    default public boolean isSlotAccessible(int slot) {
        return false;
    }

    default public int getStackLimit(int slot, ItemStack stack) {
        return 0;
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, TriFunction<Integer, ItemStack, Boolean, ItemStack> insertSuper) {
        return stack;
    }

    default public void setStackInSlot(int slot, ItemStack stack, BiConsumer<Integer, ItemStack> setStackInSlotSuper) {
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }

    default public ItemStack getStackInSlot(int slot, IntFunction<ItemStack> getStackInSlotSuper) {
        return ItemStack.f_41583_;
    }

    default public boolean canBeReplaced() {
        return false;
    }

    default public int getSlots() {
        return 0;
    }

    public String getName();

    @Nullable
    default public Pair<ResourceLocation, ResourceLocation> getNoItemIcon(int slot) {
        return null;
    }

    default public Item getFilterItem(int slot) {
        return Items.f_41852_;
    }

    default public void onSlotLimitChange() {
    }

    default public Set<Integer> getNoSortSlots() {
        return Set.of();
    }

    default public void onSlotFilterChanged(int slot) {
    }

    default public boolean isFilterItem(Item item) {
        return false;
    }

    default public Map<Item, Set<Integer>> getFilterItems() {
        return Map.of();
    }

    default public void onInit() {
    }

    public static interface Factory {
        public IInventoryPartHandler create(InventoryHandler var1, InventoryPartitioner.SlotRange var2, Supplier<MemorySettingsCategory> var3);
    }

    public static class Default
    implements IInventoryPartHandler {
        public static final String NAME = "default";
        private final InventoryHandler parent;
        private final int slots;

        public Default(InventoryHandler parent, int slots) {
            this.parent = parent;
            this.slots = slots;
        }

        @Override
        public int getSlotLimit(int slot) {
            return this.parent.getBaseSlotLimit();
        }

        @Override
        public int getStackLimit(int slot, ItemStack stack) {
            return this.parent.getBaseStackLimit(stack);
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.parent.extractItemInternal(slot, amount, simulate);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, TriFunction<Integer, ItemStack, Boolean, ItemStack> insertSuper) {
            return (ItemStack)insertSuper.apply((Object)slot, (Object)stack, (Object)simulate);
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack, BiConsumer<Integer, ItemStack> setStackInSlotSuper) {
            setStackInSlotSuper.accept(slot, stack);
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }

        @Override
        public ItemStack getStackInSlot(int slot, IntFunction<ItemStack> getStackInSlotSuper) {
            return getStackInSlotSuper.apply(slot);
        }

        @Override
        public boolean canBeReplaced() {
            return true;
        }

        @Override
        public boolean isSlotAccessible(int slot) {
            return true;
        }

        @Override
        public int getSlots() {
            return this.slots;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

