/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModelManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;

public class BackpackLayerRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public BackpackLayerRenderer(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
        BackpackModelManager.initModels();
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            PlayerInventoryProvider.get().getBackpackFromRendered((Player)player).ifPresent(backpackRenderInfo -> {
                matrixStack.m_85836_();
                ItemStack backpack = backpackRenderInfo.getBackpack();
                IBackpackModel model = BackpackModelManager.getBackpackModel(backpack.m_41720_());
                EquipmentSlot equipmentSlot = model.getRenderEquipmentSlot();
                boolean wearsArmor = (equipmentSlot != EquipmentSlot.CHEST || !backpackRenderInfo.isArmorSlot()) && !((ItemStack)player.m_150109_().f_35975_.get(equipmentSlot.m_20749_())).m_41619_();
                BackpackLayerRenderer.renderBackpack(this.m_117386_(), (LivingEntity)player, matrixStack, buffer, packedLight, backpack, wearsArmor, model);
                matrixStack.m_85849_();
            });
        } else {
            ItemStack chestStack = entity.m_6844_(EquipmentSlot.CHEST);
            if (chestStack.m_41720_() instanceof BackpackItem) {
                BackpackLayerRenderer.renderBackpack(this.m_117386_(), entity, matrixStack, buffer, packedLight, chestStack, false, BackpackModelManager.getBackpackModel(chestStack.m_41720_()));
            }
        }
    }

    public static <T extends LivingEntity, M extends EntityModel<T>> void renderBackpack(M parentModel, LivingEntity livingEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, ItemStack backpack, boolean wearsArmor, IBackpackModel model) {
        model.translateRotateAndScale(parentModel, livingEntity, matrixStack, wearsArmor);
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            int clothColor = wrapper.getMainColor();
            int borderColor = wrapper.getAccentColor();
            model.render(parentModel, livingEntity, matrixStack, buffer, packedLight, clothColor, borderColor, backpack.m_41720_(), wrapper.getRenderInfo());
            BackpackLayerRenderer.renderUpgrades(livingEntity, wrapper.getRenderInfo());
            BackpackLayerRenderer.renderItemShown(matrixStack, buffer, packedLight, wrapper.getRenderInfo());
        });
    }

    private static void renderItemShown(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, RenderInfo renderInfo) {
        renderInfo.getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.9, -0.25);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f + (float)displayItem.getRotation()));
            Minecraft.m_91087_().m_91291_().m_174269_(displayItem.getItem(), ItemTransforms.TransformType.FIXED, packedLight, OverlayTexture.f_118083_, matrixStack, buffer, 0);
            matrixStack.m_85849_();
        });
    }

    private static void renderUpgrades(LivingEntity livingEntity, RenderInfo renderInfo) {
        if (Minecraft.m_91087_().m_91104_() || livingEntity.f_19853_.f_46441_.m_188503_(32) != 0) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> BackpackLayerRenderer.renderUpgrade(renderer, livingEntity, type, data)));
    }

    private static Vector3f getBackpackMiddleFacePoint(LivingEntity livingEntity, Vector3f vector) {
        Vector3f point = vector.m_122281_();
        point.m_122251_(Vector3f.f_122223_.m_122240_(livingEntity.m_6047_() ? 25.0f : 0.0f));
        point.m_122272_(0.0f, 0.8f, livingEntity.m_6047_() ? 0.9f : 0.7f);
        point.m_122251_(Vector3f.f_122224_.m_122240_(livingEntity.f_20883_ - 180.0f));
        point.m_122253_(new Vector3f(livingEntity.m_20182_()));
        return point;
    }

    private static <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, LivingEntity livingEntity, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(livingEntity.f_19853_, livingEntity.f_19853_.f_46441_, vector3d -> BackpackLayerRenderer.getBackpackMiddleFacePoint(livingEntity, vector3d), renderData));
    }
}

