/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;

public class CraftedMaterialItem
extends Item
implements IColoredMaterialItem {
    private static final String NBT_MATERIAL = "Material";

    public CraftedMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public static IMaterialInstance getMaterial(ItemStack stack) {
        String id;
        IMaterial mat;
        Tag nbt = stack.m_41784_().m_128423_(NBT_MATERIAL);
        if (nbt instanceof CompoundTag) {
            MaterialInstance mat2 = MaterialInstance.read((CompoundTag)nbt);
            if (mat2 != null) {
                return mat2;
            }
        } else if (nbt != null && (mat = MaterialManager.get(SilentGear.getIdWithDefaultNamespace(id = nbt.m_7916_()))) != null) {
            return MaterialInstance.of(mat);
        }
        return LazyMaterialInstance.of(Const.Materials.EXAMPLE);
    }

    public ItemStack create(IMaterialInstance material, int count) {
        ItemStack result = new ItemStack((ItemLike)this, count);
        result.m_41784_().m_128365_(NBT_MATERIAL, (Tag)material.write(new CompoundTag()));
        return result;
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        IMaterialInstance material = CraftedMaterialItem.getMaterial(stack);
        IMaterialDisplay model = material.getDisplayProperties();
        return model.getLayerColor(GearType.ALL, PartType.MAIN, material, layer);
    }

    public Component m_7626_(ItemStack stack) {
        IMaterialInstance material = CraftedMaterialItem.getMaterial(stack);
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{material.getDisplayName(PartType.MAIN)});
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.create(LazyMaterialInstance.of(Const.Materials.EXAMPLE), 1));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41784_().m_128423_(NBT_MATERIAL) instanceof StringTag) {
            tooltip.add((Component)Component.m_237113_((String)"Has an older NBT format").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237113_((String)"May not stack with newer items").m_130940_(ChatFormatting.RED));
        }
    }
}

