/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public final class BlueprintIngredient
extends Ingredient
implements IGearIngredient {
    private final PartType partType;
    private final GearType gearType;
    @Nullable
    private ItemStack[] itemStacks;

    private BlueprintIngredient(PartType partType, GearType gearType) {
        super(Stream.of(new Ingredient.Value[0]));
        this.partType = partType;
        this.gearType = gearType;
    }

    public static <T extends Item> BlueprintIngredient of(T item) {
        ItemStack stack = new ItemStack(item);
        return new BlueprintIngredient(((IBlueprint)item).getPartType(stack), ((IBlueprint)item).getGearType(stack));
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IBlueprint).map(ItemStack::new).filter(this::testBlueprint).toArray(ItemStack[]::new);
        }
    }

    private boolean testBlueprint(ItemStack stack) {
        if (stack.m_41720_() instanceof IBlueprint) {
            IBlueprint item = (IBlueprint)stack.m_41720_();
            return item.getGearType(stack) == this.gearType && item.getPartType(stack) == this.partType;
        }
        return false;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        this.dissolve();
        return this.testBlueprint(stack);
    }

    public ItemStack[] m_43908_() {
        this.dissolve();
        return this.itemStacks;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean m_43947_() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        if (this.partType != PartType.MAIN) {
            json.addProperty("part_type", this.partType.getName().toString());
        }
        if (this.gearType != GearType.PART) {
            json.addProperty("gear_type", this.gearType.getName());
        }
        return json;
    }

    @Override
    public PartType getPartType() {
        return this.partType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public Optional<Component> getJeiHint() {
        PartGearKey key = PartGearKey.of(this.gearType, this.partType);
        MutableComponent keyText = key.getDisplayName().m_6881_();
        MutableComponent text = TextUtil.withColor(keyText, Color.DODGERBLUE);
        return Optional.of(TextUtil.translate("jei", "blueprintType", text));
    }

    public static final class Serializer
    implements IIngredientSerializer<BlueprintIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("blueprint");

        private Serializer() {
        }

        public BlueprintIngredient parse(FriendlyByteBuf buffer) {
            ResourceLocation typeName = buffer.m_130281_();
            PartType partType = PartType.get(typeName);
            if (partType == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            GearType gearType = GearType.get(buffer.m_130277_());
            if (gearType.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            return new BlueprintIngredient(partType, gearType);
        }

        public BlueprintIngredient parse(JsonObject json) {
            String typeName = GsonHelper.m_13851_((JsonObject)json, (String)"part_type", (String)"main");
            PartType type = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(typeName)));
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            String gearTypeName = GsonHelper.m_13851_((JsonObject)json, (String)"gear_type", (String)"part");
            GearType gearType = GearType.get(gearTypeName);
            if (gearType.isInvalid()) {
                throw new JsonSyntaxException("gear_type " + gearTypeName + " does not exist");
            }
            return new BlueprintIngredient(type, gearType);
        }

        public void write(FriendlyByteBuf buffer, BlueprintIngredient ingredient) {
            buffer.m_130085_(ingredient.partType.getName());
            buffer.m_130070_(ingredient.gearType.getName());
        }
    }
}

