/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.grader;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.block.grader.GraderContainer;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.SgBlockEntities;
import net.silentchaos512.gear.init.SgTags;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.EnumUtils;

public class GraderTileEntity
extends LockableSidedInventoryTileEntity {
    static final int BASE_ANALYZE_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 1.0f : 5.0f));
    static final int INPUT_SLOT = 0;
    static final int CATALYST_SLOT = 1;
    private static final int[] SLOTS_INPUT = new int[]{0, 1};
    private static final int[] SLOTS_OUTPUT = new int[]{2, 3, 4, 5};
    static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, INVENTORY_SIZE).toArray();
    @SyncVariable(name="progress")
    private int progress = 0;
    private MaterialGrade lastGradeAttempt = MaterialGrade.NONE;
    private boolean requireClientSync = false;
    private final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return GraderTileEntity.this.progress;
                }
                case 1: {
                    return GraderTileEntity.this.lastGradeAttempt.ordinal();
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    GraderTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    GraderTileEntity.this.lastGradeAttempt = (MaterialGrade)EnumUtils.byOrdinal((int)value, (Enum)MaterialGrade.NONE);
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public GraderTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.MATERIAL_GRADER.get(), INVENTORY_SIZE, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GraderTileEntity blockEntity) {
        ItemStack input = blockEntity.getInputStack();
        if (input.m_41619_()) {
            return;
        }
        int outputSlot = blockEntity.getFreeOutputSlot();
        if (outputSlot < 0) {
            return;
        }
        ItemStack catalyst = blockEntity.getCatalystStack();
        int catalystTier = GraderTileEntity.getCatalystTier(catalyst);
        if (catalystTier < 1) {
            return;
        }
        MaterialInstance material = MaterialInstance.from(input);
        if (material != null && material.getGrade() != MaterialGrade.getMax()) {
            if (blockEntity.progress < BASE_ANALYZE_TIME) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= BASE_ANALYZE_TIME && !level.f_46443_) {
                blockEntity.progress = 0;
                catalyst.m_41774_(1);
                blockEntity.tryGradeItem(input, catalystTier, material);
            }
        } else {
            blockEntity.progress = 0;
        }
    }

    private void tryGradeItem(ItemStack input, int catalystTier, IMaterialInstance material) {
        MaterialGrade targetGrade;
        this.lastGradeAttempt = targetGrade = MaterialGrade.selectWithCatalyst(SilentGear.RANDOM, catalystTier);
        if (targetGrade.ordinal() > material.getGrade().ordinal()) {
            ItemStack stack = input.m_41620_(1);
            targetGrade.setGradeOnStack(stack);
            InventoryUtils.mergeItem((Container)this, (int)2, (int)(2 + SLOTS_OUTPUT.length), (ItemStack)stack);
        }
    }

    public boolean m_7983_() {
        return this.getInputStack().m_41619_();
    }

    private ItemStack getInputStack() {
        MaterialInstance material;
        ItemStack stack = this.m_8020_(0);
        if (!stack.m_41619_() && (material = MaterialInstance.from(stack)) != null && material.getGrade() != MaterialGrade.getMax()) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private ItemStack getCatalystStack() {
        return this.m_8020_(1);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.m_8020_(slot).m_41619_()) continue;
            return slot;
        }
        return -1;
    }

    static boolean canAcceptInput(ItemStack stack) {
        MaterialInstance material = MaterialInstance.from(stack);
        return material != null && material.getGrade() != MaterialGrade.getMax();
    }

    public static int getCatalystTier(ItemStack stack) {
        if (!stack.m_41619_()) {
            for (int i = SgTags.Items.GRADER_CATALYSTS_TIERS.size() - 1; i >= 0; --i) {
                if (!stack.m_204117_(SgTags.Items.GRADER_CATALYSTS_TIERS.get(i))) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundTag)tags);
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundTag)tags, (SyncVariable.Type)SyncVariable.Type.WRITE);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, this::getTagsForUpdatePacket);
    }

    private CompoundTag getTagsForUpdatePacket(BlockEntity be) {
        CompoundTag tags = this.m_5995_();
        ItemStack input = this.getInputStack();
        if (!input.m_41619_()) {
            CompoundTag itemTags = input.serializeNBT();
            tags.m_128365_("input_item", (Tag)itemTags);
        }
        return tags;
    }

    public CompoundTag m_5995_() {
        CompoundTag tags = super.m_5995_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundTag)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        ListTag tagList = new ListTag();
        ItemStack input = this.getInputStack();
        if (!input.m_41619_()) {
            CompoundTag itemTags = input.serializeNBT();
            itemTags.m_128344_("Slot", (byte)0);
            tagList.add((Object)itemTags);
        }
        tags.m_128365_("Items", (Tag)tagList);
        return tags;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        CompoundTag tags = packet.m_131708_();
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundTag)tags);
        if (tags.m_128441_("input_item")) {
            this.m_6836_(0, ItemStack.m_41712_((CompoundTag)tags.m_128469_("input_item")));
        } else {
            this.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public int[] m_7071_(Direction side) {
        switch (side) {
            case UP: {
                return SLOTS_INPUT;
            }
            case DOWN: {
                return SLOTS_OUTPUT;
            }
        }
        return SLOTS_ALL;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index != 0 && index != 1) {
            return false;
        }
        ItemStack stackInSlot = this.m_8020_(index);
        if (stack.m_41619_() || !stackInSlot.m_41619_() && !stackInSlot.m_41656_(stack)) {
            return false;
        }
        if (index == 0) {
            return GraderTileEntity.canAcceptInput(stack);
        }
        return GraderTileEntity.getCatalystTier(stack) > 0;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index != 0 && index != 1;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.silentgear.material_grader");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new GraderContainer(id, playerInventory, (Container)this, this.fields);
    }
}

