/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.IStatItem;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TraitHelper;

public interface ICoreItem
extends ItemLike,
IStatItem {
    default public ItemStack construct(Collection<? extends IPartData> parts) {
        ItemStack result = new ItemStack((ItemLike)this);
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateStats(result, null);
        parts.forEach(p -> p.onAddToGear(result));
        TraitHelper.activateTraits(result, 0.0f, (trait, level, nothing) -> {
            trait.onGearCrafted(new TraitActionContext(null, level, result));
            return 0.0f;
        });
        return result;
    }

    default public Item m_5456_() {
        return (Item)this;
    }

    public GearType getGearType();

    default public boolean isValidSlot(String slot) {
        return false;
    }

    default public boolean requiresPartOfType(PartType type) {
        return this.getRequiredParts().contains(type);
    }

    default public boolean supportsPart(ItemStack gear, PartData part) {
        boolean canAdd = part.get().canAddToGear(gear, part);
        return this.requiresPartOfType(part.getType()) && canAdd || canAdd;
    }

    default public Collection<PartType> getRequiredParts() {
        return ImmutableList.of((Object)PartType.MAIN);
    }

    @Override
    default public float getStat(ItemStack stack, ItemStat stat) {
        return GearData.getStat(stack, stat);
    }

    public Set<ItemStat> getRelevantStats(ItemStack var1);

    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return Collections.emptySet();
    }

    @Deprecated
    default public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        return Optional.empty();
    }

    @Deprecated
    default public Optional<StatInstance> getStatModifier(ItemStat stat) {
        return Optional.empty();
    }

    default public ItemStat getDurabilityStat() {
        return this.getGearType().getDurabilityStat();
    }

    default public float getRepairModifier(ItemStack stack) {
        return 1.0f;
    }

    default public Collection<PartType> getRenderParts() {
        return ImmutableList.of((Object)PartType.ROD, (Object)PartType.MAIN, (Object)PartType.COATING, (Object)PartType.BINDING, (Object)PartType.GRIP, (Object)PartType.CORD, (Object)PartType.TIP, (Object)PartType.MISC_UPGRADE);
    }

    default public int getAnimationFrames() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getAnimationFrame(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public ItemColor getItemColors() {
        return (stack, tintIndex) -> switch (tintIndex) {
            case 0 -> ColorUtils.getBlendedColor(stack, PartType.ROD);
            case 1 -> {
                if (GearData.hasPartOfType(stack, PartType.COATING)) {
                    yield ColorUtils.getBlendedColor(stack, PartType.COATING);
                }
                yield ColorUtils.getBlendedColor(stack, PartType.MAIN);
            }
            case 3 -> ColorUtils.getBlendedColor(stack, PartType.TIP);
            case 4 -> ColorUtils.getBlendedColor(stack, PartType.GRIP);
            default -> 0xFFFFFF;
        };
    }

    default public boolean hasTexturesFor(PartType partType) {
        return true;
    }
}

