/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TagHelper {
    public static final TagKey<Item> ITEM_DUMMY = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("empty_dummy_tag"));
    private static final HashMap<ResourceLocation, TagKey<Item>> ITEM_TAGS = new HashMap();
    public static final TagKey<Block> BLOCK_DUMMY = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("empty_dummy_tag"));
    private static final HashMap<ResourceLocation, TagKey<Block>> BLOCK_TAGS = new HashMap();

    public static TagKey<Item> getItemTagKey(ResourceLocation tagId) {
        if (!ITEM_TAGS.containsKey(tagId)) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagId);
            ITEM_TAGS.put(tagId, (TagKey<Item>)tag);
        }
        return ITEM_TAGS.getOrDefault(tagId, ITEM_DUMMY);
    }

    public static TagKey<Item> getItemTagKey(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getItemTagKey(new ResourceLocation(tagId.toLowerCase(Locale.ROOT))) : ITEM_DUMMY;
    }

    public static boolean isItemInTag(ItemStack stack, TagKey<Item> tagKey) {
        return !stack.m_41619_() && TagHelper.isItemInTag(stack.m_41720_(), tagKey);
    }

    public static boolean isItemInTag(Item item, TagKey<Item> tagKey) {
        if (item != null && tagKey != null) {
            Holder.Reference entry = item.m_204114_();
            return entry != null && entry.m_203656_(tagKey);
        }
        return false;
    }

    public static boolean isItemInTag(ItemStack stack, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isItemInTag(stack, TagHelper.getItemTagKey(tagId));
    }

    public static boolean isItemInTag(Item item, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isItemInTag(item, TagHelper.getItemTagKey(tagId));
    }

    public static boolean isItemInTag(ItemStack stack, Check check, Object ... tags) {
        return !stack.m_41619_() && TagHelper.isItemInTag(stack.m_41720_(), check, tags);
    }

    public static boolean isItemInTag(Item item, Check check, Object ... tags) {
        Holder.Reference entry;
        if (item != null && (entry = item.m_204114_()) != null) {
            for (Object tagId : tags) {
                TagKey tagKey;
                TagKey tag = null;
                if (tagId instanceof String) {
                    String string = (String)tagId;
                    if (!Strings.isNullOrEmpty((String)string)) {
                        tag = TagHelper.getItemTagKey(string);
                    }
                } else if (tagId instanceof TagKey && (tagKey = (TagKey)tagId).f_203867_() == Registry.f_122904_) {
                    tag = (TagKey)tagId;
                }
                if (tag == null) continue;
                if (entry.m_203656_(tag)) {
                    if (check != Check.ANY) continue;
                    return true;
                }
                if (check != Check.ALL) continue;
                return false;
            }
        }
        return false;
    }

    public static Collection<Item> getItems(TagKey<Item> tagKey) {
        ArrayList list = Lists.newArrayList();
        for (Holder holder : Registry.f_122827_.m_206058_(tagKey)) {
            list.add((Item)holder.m_203334_());
        }
        return list;
    }

    public static Collection<Item> getItems(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getItems(TagHelper.getItemTagKey(tagId)) : Collections.emptyList();
    }

    @NotNull
    public static ItemStack getItemStack(String tagId, int ... stackSize) {
        Collection<Item> results;
        int amount;
        int n = amount = stackSize != null && stackSize.length > 0 ? stackSize[0] : 1;
        if (amount > 0 && (results = TagHelper.getItems(tagId)) != null && !results.isEmpty()) {
            for (Item item : results) {
                if (item == null) continue;
                return new ItemStack((ItemLike)item, amount);
            }
        }
        return ItemStack.f_41583_;
    }

    public static Stream<TagKey<Item>> getTags(ItemStack stack) {
        return !stack.m_41619_() ? TagHelper.getTags(stack.m_41720_()) : Collections.EMPTY_SET.stream();
    }

    public static Stream<TagKey<Item>> getTags(Item item) {
        return item != null ? item.m_204114_().m_203616_() : Collections.EMPTY_SET.stream();
    }

    public static TagKey<Block> getBlockTagKey(ResourceLocation tagId) {
        if (!BLOCK_TAGS.containsKey(tagId)) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tagId);
            BLOCK_TAGS.put(tagId, (TagKey<Block>)tag);
        }
        return BLOCK_TAGS.getOrDefault(tagId, BLOCK_DUMMY);
    }

    public static TagKey<Block> getBlockTagKey(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getBlockTagKey(new ResourceLocation(tagId.toLowerCase(Locale.ROOT))) : BLOCK_DUMMY;
    }

    public static boolean isBlockInTag(BlockState state, TagKey<Block> tagKey) {
        return state != null && TagHelper.isBlockInTag(state.m_60734_(), tagKey);
    }

    public static boolean isBlockInTag(Block block, TagKey<Block> tagKey) {
        if (block != null && tagKey != null) {
            Holder.Reference entry = block.m_204297_();
            return entry != null && entry.m_203656_(tagKey);
        }
        return false;
    }

    public static boolean isBlockInTag(BlockState state, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isBlockInTag(state, TagHelper.getBlockTagKey(tagId));
    }

    public static boolean isBlockInTag(Block block, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isBlockInTag(block, TagHelper.getBlockTagKey(tagId));
    }

    public static boolean isBlockInTag(BlockState state, Check check, Object ... tags) {
        return state != null && TagHelper.isBlockInTag(state.m_60734_(), check, tags);
    }

    public static boolean isBlockInTag(Block block, Check check, Object ... tags) {
        Holder.Reference entry;
        if (block != null && (entry = block.m_204297_()) != null) {
            for (Object tagId : tags) {
                TagKey tagKey;
                TagKey tag = null;
                if (tagId instanceof String) {
                    String string = (String)tagId;
                    if (!Strings.isNullOrEmpty((String)string)) {
                        tag = TagHelper.getBlockTagKey(string);
                    }
                } else if (tagId instanceof TagKey && (tagKey = (TagKey)tagId).f_203867_() == Registry.f_122901_) {
                    tag = (TagKey)tagId;
                }
                if (tag == null) continue;
                if (entry.m_203656_(tag)) {
                    if (check != Check.ANY) continue;
                    return true;
                }
                if (check != Check.ALL) continue;
                return false;
            }
        }
        return false;
    }

    public static Collection<Block> getBlocks(TagKey<Block> tagKey) {
        ArrayList list = Lists.newArrayList();
        for (Holder holder : Registry.f_122824_.m_206058_(tagKey)) {
            list.add((Block)holder.m_203334_());
        }
        return list;
    }

    public static Collection<Block> getBlocks(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getBlocks(TagHelper.getBlockTagKey(tagId)) : Collections.emptyList();
    }

    public static Stream<TagKey<Block>> getTags(BlockState state) {
        return state != null ? TagHelper.getTags(state.m_60734_()) : Collections.EMPTY_SET.stream();
    }

    public static Stream<TagKey<Block>> getTags(Block block) {
        return block != null ? block.m_204297_().m_203616_() : Collections.EMPTY_SET.stream();
    }

    public static enum Check {
        ANY,
        ALL;

    }
}

