/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import shetiphian.core.client.GuiFunctions;

public class BasicUiElement {
    private final int localX;
    private final int localY;
    protected final int width;
    protected final int height;
    protected final int[] normal;
    protected final int[] hover;
    protected final float scale;
    public final String name;
    public final String tooltip;
    public boolean visible = true;
    public boolean enabled = true;
    private Action action;
    private SimpleAction simpleAction;
    protected int x;
    protected int y;

    public BasicUiElement(int localX, int localY, int width, int height, int nU, int nV, int hU, int hV, float scale, String name, String tooltip) {
        this.localX = localX;
        this.localY = localY;
        this.width = width;
        this.height = height;
        this.normal = new int[]{nU, nV};
        this.hover = new int[]{hU, hV};
        this.scale = scale;
        this.name = name;
        this.tooltip = tooltip;
    }

    public BasicUiElement(int localX, int localY, int width, int height, int nU, int nV, int hU, int hV, float scale, String name, String tooltip, Action action) {
        this(localX, localY, width, height, nU, nV, hU, hV, scale, name, tooltip);
        this.action = action;
    }

    public BasicUiElement(int localX, int localY, int width, int height, int nU, int nV, int hU, int hV, float scale, String name, String tooltip, SimpleAction action) {
        this(localX, localY, width, height, nU, nV, hU, hV, scale, name, tooltip);
        this.simpleAction = action;
    }

    public void setScreenOffset(int x, int y) {
        this.x = x + this.localX;
        this.y = y + this.localY;
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            GuiFunctions.drawTextureScaled(matrixStack, this.x, this.y, this.hover[0], this.hover[1], this.width, this.height, this.scale, 1.0f, new int[0]);
        } else {
            GuiFunctions.drawTextureScaled(matrixStack, this.x, this.y, this.normal[0], this.normal[1], this.width, this.height, this.scale, 1.0f, new int[0]);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)((float)this.x + (float)this.width * this.scale) && mouseY < (double)((float)this.y + (float)this.height * this.scale);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.enabled && this.isMouseOver(mouseX, mouseY)) {
            if (this.action != null) {
                this.action.run(mouseX, mouseY, button);
                return true;
            }
            if (this.simpleAction != null) {
                this.simpleAction.run();
                return true;
            }
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @FunctionalInterface
    public static interface Action {
        public void run(double var1, double var3, int var5);
    }

    @FunctionalInterface
    public static interface SimpleAction {
        public void run();
    }
}

