/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.saturn.common.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SaturnConfig {
    public static final String SATURN_GITHUB_ISSUE_TRACKER = "https://github.com/AbdElAziz333/Saturn/issues";
    public static final ForgeConfigSpec SPEC;
    public static final SaturnCommon COMMON;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(SaturnCommon::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        COMMON = (SaturnCommon)pair.getLeft();
    }

    public static class SaturnCommon {
        public final ForgeConfigSpec.BooleanValue CLEAR_MEMORIES_LEAK_FIX;
        public final ForgeConfigSpec.BooleanValue READ_RESOURCE_LEAK_FIX;
        public final ForgeConfigSpec.BooleanValue BIOME_TEMPERATURE_CACHE_LEAK_FIX;
        public final ForgeConfigSpec.BooleanValue TICKING_TRACKER_LEAK_FIX;
        public final ForgeConfigSpec.BooleanValue UNNECESSARY_OBJECT_CREATION;
        public final ForgeConfigSpec.BooleanValue THREADING_DETECTOR_LOCK;

        SaturnCommon(ForgeConfigSpec.Builder builder) {
            builder.comment("This is the config file of Saturn\nTo get the best performance, i'd recommended to set all the options to true, \nuntil you got an issue or compatibility with other mod,\\nIf you do, please report the issue in the issue tracker from the link linked below:\nhttps://github.com/AbdElAziz333/Saturn/issues");
            builder.push("Memory Leak Fixes");
            this.BIOME_TEMPERATURE_CACHE_LEAK_FIX = builder.comment("Set this to true to enable biome temperature cache leak fix.").define("biomeTemperatureCacheLeakFix", true);
            this.CLEAR_MEMORIES_LEAK_FIX = builder.comment("Set this to true to enable Ai clear memories leak fix.").define("clearMemoriesLeakFix", true);
            this.READ_RESOURCE_LEAK_FIX = builder.comment("Set this to true to enable read resource leak fix.").define("readResourceLeakFix", true);
            this.TICKING_TRACKER_LEAK_FIX = builder.comment("Set this to true to enable ticking tracker leak fix.").define("tickingTrackerLeakFix", true);
            builder.pop();
            builder.push("Reduce Garbage Collection (GC) Heap Optimizations");
            this.UNNECESSARY_OBJECT_CREATION = builder.comment("Avoid unnecessary object creation").define("avoidUnnecessaryObjectCreation", true);
            builder.pop();
            builder.push("Miscellaneous");
            this.THREADING_DETECTOR_LOCK = builder.comment("Disable threading detector lock duplication").define("disableThreadingDetectorLock", true);
            builder.pop();
        }
    }
}

