/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.InventoryTools;
import mcjty.rftoolsutility.modules.crafter.data.CraftMode;
import mcjty.rftoolsutility.modules.crafter.data.KeepMode;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CraftingRecipe {
    private final CraftingContainer inv = new CraftingContainer(new AbstractContainerMenu(null, -1){

        public boolean m_6875_(@Nonnull Player var1) {
            return false;
        }

        public ItemStack m_7648_(Player player, int slot) {
            return ItemStack.f_41583_;
        }
    }, 3, 3);
    private ItemStack result = ItemStack.f_41583_;
    private boolean recipePresent = false;
    private Recipe recipe = null;
    private KeepMode keepOne = KeepMode.ALL;
    private CraftMode craftMode = CraftMode.EXT;
    private List<CompressedIngredient> compressedIngredients = null;

    public List<CompressedIngredient> getCompressedIngredients() {
        if (this.compressedIngredients == null) {
            this.compressedIngredients = new ArrayList<CompressedIngredient>();
            for (int i = 0; i < this.inv.m_6643_(); ++i) {
                ItemStack stack = this.inv.m_8020_(i);
                if (stack.m_41619_()) continue;
                boolean found = false;
                for (CompressedIngredient ingredient : this.compressedIngredients) {
                    if (!InventoryTools.isItemStackConsideredEqual((ItemStack)stack, (ItemStack)ingredient.getStack())) continue;
                    ingredient.getStack().m_41769_(stack.m_41613_());
                    int[] nArray = ingredient.getGridDistribution();
                    int n = i;
                    nArray[n] = nArray[n] + stack.m_41613_();
                    found = true;
                    break;
                }
                if (found) continue;
                CompressedIngredient ingredient = new CompressedIngredient(stack.m_41777_());
                int[] nArray = ingredient.getGridDistribution();
                int n = i;
                nArray[n] = nArray[n] + stack.m_41613_();
                this.compressedIngredients.add(ingredient);
            }
        }
        return this.compressedIngredients;
    }

    public static Recipe findRecipe(Level world, CraftingContainer inv) {
        RecipeManager recipeManager = world.m_7465_();
        for (Recipe r : recipeManager.m_44051_()) {
            if (r == null || !RecipeType.f_44107_.equals(r.m_6671_()) || !r.m_5818_((Container)inv, world)) continue;
            return r;
        }
        return null;
    }

    public void readFromNBT(CompoundTag tagCompound) {
        ListTag nbtTagList = tagCompound.m_128437_("Items", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            this.inv.m_6836_(i, ItemStack.m_41712_((CompoundTag)nbtTagList.m_128728_(i)));
        }
        CompoundTag resultCompound = tagCompound.m_128469_("Result");
        this.result = ItemStack.m_41712_((CompoundTag)resultCompound);
        this.keepOne = tagCompound.m_128471_("Keep") ? KeepMode.KEEP : KeepMode.ALL;
        this.craftMode = CraftMode.values()[tagCompound.m_128445_("Int")];
        this.recipePresent = false;
    }

    public void writeToNBT(CompoundTag tagCompound) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.inv.m_6643_(); ++i) {
            ItemStack stack = this.inv.m_8020_(i);
            CompoundTag tag = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(tag);
            }
            nbtTagList.add((Object)tag);
        }
        CompoundTag resultCompound = new CompoundTag();
        if (!this.result.m_41619_()) {
            this.result.m_41739_(resultCompound);
        }
        tagCompound.m_128365_("Result", (Tag)resultCompound);
        tagCompound.m_128365_("Items", (Tag)nbtTagList);
        tagCompound.m_128379_("Keep", this.keepOne == KeepMode.KEEP);
        tagCompound.m_128344_("Int", (byte)this.craftMode.ordinal());
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        for (int i = 0; i < this.inv.m_6643_(); ++i) {
            this.inv.m_6836_(i, items[i]);
        }
        this.result = result;
        this.recipePresent = false;
    }

    public CraftingContainer getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Recipe getCachedRecipe(Level world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = CraftingRecipe.findRecipe(world, this.inv);
            this.compressedIngredients = null;
        }
        return this.recipe;
    }

    public KeepMode getKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(KeepMode keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    public static class CompressedIngredient {
        private final ItemStack stack;
        private final int[] gridDistribution = new int[9];

        public CompressedIngredient(ItemStack stack) {
            this.stack = stack;
            Arrays.fill(this.gridDistribution, 0);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int[] getGridDistribution() {
            return this.gridDistribution;
        }
    }
}

