/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class MineshaftEndStructure
extends Structure {
    public static final Codec<MineshaftEndStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MineshaftEndStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.f_135803_.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("min_island_thickness_allowed").forGetter(config -> config.minIslandThickness)).apply((Applicative)instance, MineshaftEndStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    public final int size;
    public final Optional<Integer> minYAllowed;
    public final Optional<Integer> maxYAllowed;
    public final Optional<Integer> allowedYRangeFromStart;
    public final HeightProvider startHeight;
    public final Optional<Integer> biomeRadius;
    public final HashSet<ResourceLocation> poolsThatIgnoreBoundaries;
    public final Optional<Integer> maxDistanceFromCenter;
    public final Optional<Integer> minIslandThickness;

    public MineshaftEndStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, HeightProvider startHeight, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<Integer> minIslandThickness) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.minYAllowed = minYAllowed;
        this.maxYAllowed = maxYAllowed;
        this.allowedYRangeFromStart = allowedYRangeFromStart;
        this.startHeight = startHeight;
        this.biomeRadius = biomeRadius;
        this.poolsThatIgnoreBoundaries = poolsThatIgnoreBoundaries;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.minIslandThickness = minIslandThickness;
        if (maxYAllowed.isPresent() && minYAllowed.isPresent() && maxYAllowed.get() < minYAllowed.get()) {
            throw new RuntimeException("    Repurposed Structures: maxYAllowed cannot be less than minYAllowed.\n    Please correct this error as there's no way to spawn this structure properly\n        Structure pool of problematic structure: %s\n".formatted(((StructureTemplatePool)startPool.get()).m_210587_()));
        }
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        if (this.minIslandThickness.isEmpty()) {
            return true;
        }
        BlockPos.MutableBlockPos islandTopBottomThickness = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int xPos = blockPos.m_123341_();
        int zPos = blockPos.m_123343_();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = direction.m_122432_();
                offsetPos.m_122261_(30.0f * (float)i);
                landHeight = MineshaftEndStructure.getHeightAt(context, xPos + (int)offsetPos.m_122239_(), zPos + (int)offsetPos.m_122269_(), landHeight);
                if (landHeight - context.f_226622_().m_142062_() >= this.minIslandThickness.get()) continue;
                return false;
            }
        }
        MineshaftEndStructure.analyzeLand(context, xPos, zPos, islandTopBottomThickness, context.f_226629_());
        return islandTopBottomThickness.m_123343_() >= this.minIslandThickness.get();
    }

    private static int getHeightAt(Structure.GenerationContext context, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, context.f_226622_().m_223235_(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()));
        return landHeight;
    }

    private static void analyzeLand(Structure.GenerationContext context, int xPos, int zPos, BlockPos.MutableBlockPos islandTopBottomThickness, LevelHeightAccessor heightLimitView) {
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(xPos, zPos, heightLimitView, context.f_226624_());
        int minY = context.f_226622_().m_142062_();
        int rangeHeight = GeneralUtils.getMaxTerrainLimit(context.f_226622_());
        int maxY = minY + rangeHeight;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(xPos, maxY, zPos);
        boolean isInIsland = false;
        while (currentPos.m_123342_() >= minY) {
            BlockState state = columnOfBlocks.m_183556_(currentPos.m_123342_());
            if (!state.m_60795_() && !isInIsland) {
                isInIsland = true;
                int topIslandY = Math.min(currentPos.m_123342_(), islandTopBottomThickness.m_123341_());
                islandTopBottomThickness.m_122178_(topIslandY, islandTopBottomThickness.m_123342_(), islandTopBottomThickness.m_123343_());
            } else if (state.m_60795_() && isInIsland || currentPos.m_123342_() == minY) {
                int bottomIslandY = Math.max(currentPos.m_123342_(), islandTopBottomThickness.m_123342_());
                islandTopBottomThickness.m_122178_(islandTopBottomThickness.m_123341_(), bottomIslandY, islandTopBottomThickness.m_123343_());
                break;
            }
            currentPos.m_122173_(Direction.DOWN);
        }
        if (!isInIsland) {
            islandTopBottomThickness.m_122178_(0, 0, 0);
        }
        int thickness = islandTopBottomThickness.m_123341_() - islandTopBottomThickness.m_123342_();
        islandTopBottomThickness.m_122178_(islandTopBottomThickness.m_123341_(), islandTopBottomThickness.m_123342_(), thickness);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.f_226628_().m_45604_(), 0, context.f_226628_().m_45605_());
        if (!this.extraSpawningChecks(context, (BlockPos)blockpos)) {
            return Optional.empty();
        }
        BlockPos.MutableBlockPos islandTopBottomThickness = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        MineshaftEndStructure.analyzeLand(context, blockpos.m_123341_(), blockpos.m_123343_(), islandTopBottomThickness, context.f_226629_());
        int maxY = 53;
        int minY = 15;
        if (this.minIslandThickness.isEmpty()) {
            blockpos.m_122175_(Direction.UP, 35);
        } else {
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
            int structureStartHeight = random.m_188503_(Math.max(islandTopBottomThickness.m_123343_() - this.minIslandThickness.get() + 1, 1)) + islandTopBottomThickness.m_123342_() + this.minIslandThickness.get() / 2;
            blockpos.m_122175_(Direction.UP, structureStartHeight);
            maxY = islandTopBottomThickness.m_123341_() - 10;
            minY = islandTopBottomThickness.m_123342_();
            if (maxY - minY <= 10) {
                minY = maxY - 10;
            }
        }
        int finalMaxY = maxY;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.f_226621_().m_175515_(Registry.f_235725_).m_7981_((Object)this), (BlockPos)blockpos, false, Optional.empty(), maxY, minY, this.poolsThatIgnoreBoundaries, this.maxDistanceFromCenter, Optional.empty(), (structurePiecesBuilder, pieces) -> {
            Optional<PoolElementStructurePiece> highestPiece = pieces.stream().max(Comparator.comparingInt(p -> p.m_73547_().m_162400_()));
            int topY = highestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.m_73547_().m_162400_()).orElseGet(() -> ((BlockPos.MutableBlockPos)blockpos).m_123342_());
            if (topY > finalMaxY) {
                int newOffset = finalMaxY - topY;
                for (StructurePiece piece : pieces) {
                    piece.m_6324_(0, newOffset, 0);
                }
            }
        });
    }

    public StructureType<?> m_213658_() {
        return (StructureType)RSStructures.MINESHAFT_END.get();
    }
}

