/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import reliquary.init.ModItems;
import reliquary.items.util.IPotionItem;
import reliquary.util.potions.XRPotionHelper;

public class PotionEffectsRecipe
implements CraftingRecipe {
    private final ShapedRecipe compose;
    private final float potionDurationFactor;

    private PotionEffectsRecipe(ShapedRecipe compose, float potionDurationFactor) {
        this.compose = compose;
        this.potionDurationFactor = potionDurationFactor;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack newOutput = this.compose.m_8043_().m_41777_();
        this.findMatchAndUpdateEffects(inv).ifPresent(targetEffects -> XRPotionHelper.addPotionEffectsToStack(newOutput, targetEffects));
        return newOutput;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.compose.getRecipeWidth() && height >= this.compose.getRecipeHeight();
    }

    private Optional<List<MobEffectInstance>> findMatchAndUpdateEffects(CraftingContainer inv) {
        for (int startX = 0; startX <= inv.m_39347_() - this.compose.getRecipeWidth(); ++startX) {
            for (int startY = 0; startY <= inv.m_39346_() - this.compose.getRecipeHeight(); ++startY) {
                ArrayList<Object> targetEffects = new ArrayList<MobEffectInstance>();
                if (this.checkMatchAndUpdateEffects(inv, targetEffects, startX, startY, false)) {
                    return Optional.of(targetEffects);
                }
                targetEffects = new ArrayList();
                if (!this.checkMatchAndUpdateEffects(inv, targetEffects, startX, startY, true)) continue;
                return Optional.of(targetEffects);
            }
        }
        return Optional.empty();
    }

    private boolean checkMatchAndUpdateEffects(CraftingContainer inv, List<MobEffectInstance> targetEffects, int startX, int startY, boolean mirror) {
        for (int x = 0; x < this.compose.getRecipeWidth(); ++x) {
            for (int y = 0; y < this.compose.getRecipeHeight(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = this.getTarget(subX, subY, mirror);
                if (!target.test(inv.m_8020_(x + y * inv.m_39347_()))) {
                    return false;
                }
                this.updateTargetEffects(inv, targetEffects, x, y);
            }
        }
        return true;
    }

    public boolean matches(CraftingContainer inv, Level world) {
        for (int x = 0; x <= inv.m_39347_() - this.compose.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.m_39346_() - this.compose.getRecipeHeight(); ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingContainer inv, int startX, int startY, boolean mirror) {
        ArrayList<MobEffectInstance> targetEffects = new ArrayList<MobEffectInstance>();
        for (int x = 0; x < inv.m_39347_(); ++x) {
            for (int y = 0; y < inv.m_39346_(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = this.getTarget(subX, subY, mirror);
                if (!target.test(inv.m_8020_(x + y * inv.m_39347_()))) {
                    return false;
                }
                if (this.updateTargetEffects(inv, targetEffects, x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_8043_() {
        return this.compose.m_8043_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.compose.m_7527_();
    }

    public ResourceLocation m_6423_() {
        return this.compose.m_6423_();
    }

    private Ingredient getTarget(int subX, int subY, boolean mirror) {
        if (subX >= 0 && subY >= 0 && subX < this.compose.getRecipeWidth() && subY < this.compose.getRecipeHeight()) {
            if (mirror) {
                return (Ingredient)this.compose.m_7527_().get(this.compose.getRecipeWidth() - subX - 1 + subY * this.compose.getRecipeWidth());
            }
            return (Ingredient)this.compose.m_7527_().get(subX + subY * this.compose.getRecipeWidth());
        }
        return Ingredient.f_43901_;
    }

    private boolean updateTargetEffects(CraftingContainer inv, List<MobEffectInstance> targetEffects, int x, int y) {
        ItemStack invStack = inv.m_8020_(x + y * inv.m_39347_());
        Item item = invStack.m_41720_();
        if (item instanceof IPotionItem) {
            IPotionItem potionItem = (IPotionItem)item;
            List<MobEffectInstance> effects = potionItem.getEffects(invStack);
            if (effects.isEmpty()) {
                return true;
            }
            if (targetEffects.isEmpty()) {
                targetEffects.addAll(XRPotionHelper.changePotionEffectsDuration(effects, this.potionDurationFactor));
            } else {
                return XRPotionHelper.changePotionEffectsDuration(effects, this.potionDurationFactor).equals(targetEffects);
            }
        }
        return true;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.POTION_EFFECTS_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<PotionEffectsRecipe> {
        public PotionEffectsRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new PotionEffectsRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json), GsonHelper.m_13820_((JsonObject)json, (String)"duration_factor", (float)1.0f));
        }

        @Nullable
        public PotionEffectsRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new PotionEffectsRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer), buffer.readFloat());
        }

        public void toNetwork(FriendlyByteBuf buffer, PotionEffectsRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe.compose);
            buffer.writeFloat(recipe.potionDurationFactor);
        }
    }
}

