/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.cauldron;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import reliquary.compat.jei.cauldron.CauldronRecipeJEI;
import reliquary.init.ModItems;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionMap;
import reliquary.util.potions.XRPotionHelper;

public class CauldronRecipeMaker {
    private CauldronRecipeMaker() {
    }

    public static List<CauldronRecipeJEI> getRecipes() {
        ArrayList<CauldronRecipeJEI> recipes = new ArrayList<CauldronRecipeJEI>();
        for (PotionEssence essence : PotionMap.uniquePotions) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            ItemStack potionEssence = new ItemStack((ItemLike)ModItems.POTION_ESSENCE.get(), 1);
            XRPotionHelper.addPotionEffectsToStack(potionEssence, essence.getEffects());
            inputs.add(potionEssence);
            if (essence.getRedstoneCount() > 0) {
                inputs.add(new ItemStack((ItemLike)Items.f_42451_, essence.getRedstoneCount()));
            }
            if (essence.getGlowstoneCount() > 0) {
                inputs.add(new ItemStack((ItemLike)Items.f_42525_, essence.getGlowstoneCount()));
            }
            ArrayList<ItemStack> splashInputs = new ArrayList<ItemStack>(inputs);
            ArrayList<ItemStack> lingeringInputs = new ArrayList<ItemStack>(inputs);
            splashInputs.add(new ItemStack((ItemLike)Items.f_42403_));
            lingeringInputs.add(new ItemStack((ItemLike)Items.f_42403_));
            lingeringInputs.add(new ItemStack((ItemLike)Items.f_42735_));
            inputs.add(new ItemStack((ItemLike)Items.f_42588_));
            splashInputs.add(new ItemStack((ItemLike)Items.f_42588_));
            lingeringInputs.add(new ItemStack((ItemLike)Items.f_42588_));
            inputs.add(new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get(), 3));
            splashInputs.add(new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get(), 3));
            lingeringInputs.add(new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get(), 3));
            ItemStack output = new ItemStack((ItemLike)ModItems.POTION.get(), 3);
            XRPotionHelper.addPotionEffectsToStack(output, essence.getEffects());
            ItemStack outputSplash = new ItemStack((ItemLike)ModItems.SPLASH_POTION.get(), 3);
            XRPotionHelper.addPotionEffectsToStack(outputSplash, essence.getEffects());
            ItemStack outputLingering = new ItemStack((ItemLike)ModItems.LINGERING_POTION.get(), 3);
            XRPotionHelper.addPotionEffectsToStack(outputLingering, essence.getEffects());
            recipes.add(new CauldronRecipeJEI(inputs, output));
            recipes.add(new CauldronRecipeJEI(splashInputs, outputSplash));
            recipes.add(new CauldronRecipeJEI(lingeringInputs, outputLingering));
        }
        return recipes;
    }
}

