/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import reliquary.reference.Settings;

public class FertileLilyPadBlock
extends BushBlock {
    private static Map<ResourceKey<Level>, Long> currentDimensionTicks = new HashMap<ResourceKey<Level>, Long>();
    private static Map<ResourceKey<Level>, Set<BlockPos>> dimensionPositionsTicked = new HashMap<ResourceKey<Level>, Set<BlockPos>>();
    private static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.WATER;
    }

    public FertileLilyPadBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60977_());
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        ResourceKey dimKey = world.m_46472_();
        if (!currentDimensionTicks.containsKey(dimKey) || currentDimensionTicks.get(dimKey).longValue() != world.m_46467_()) {
            currentDimensionTicks.put((ResourceKey<Level>)dimKey, world.m_46467_());
            dimensionPositionsTicked.put((ResourceKey<Level>)dimKey, new HashSet());
        } else if (dimensionPositionsTicked.computeIfAbsent((ResourceKey<Level>)dimKey, k -> new HashSet()).contains(pos)) {
            return;
        }
        this.growCropsNearby(world, pos, state);
        dimensionPositionsTicked.computeIfAbsent((ResourceKey<Level>)dimKey, k -> new HashSet()).add(pos);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + rand.m_188583_() / 8.0, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5 + rand.m_188583_() / 8.0, 0.0, 0.9, 0.5);
    }

    private int secondsBetweenGrowthTicks() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.secondsBetweenGrowthTicks.get();
    }

    private int tileRange() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.tileRange.get();
    }

    private int fullPotencyRange() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.fullPotencyRange.get();
    }

    private void growCropsNearby(ServerLevel world, BlockPos pos, BlockState state) {
        BlockPos.m_121940_((BlockPos)pos.m_7918_(-this.tileRange(), -1, -this.tileRange()), (BlockPos)pos.m_7918_(this.tileRange(), this.tileRange(), this.tileRange())).forEach(cropPos -> {
            if (!world.m_46805_(cropPos)) {
                return;
            }
            BlockState cropState = world.m_8055_(cropPos);
            Block cropBlock = cropState.m_60734_();
            if (this.isAllowedCropBlock(cropBlock) && (cropBlock instanceof IPlantable || cropBlock instanceof BonemealableBlock) && !(cropBlock instanceof FertileLilyPadBlock)) {
                double distance = Math.sqrt(cropPos.m_123331_((Vec3i)pos));
                this.tickCropBlock(world, (BlockPos)cropPos, cropState, cropBlock, distance);
            }
        });
        world.m_186460_(pos, state.m_60734_(), this.secondsBetweenGrowthTicks() * 20);
    }

    private boolean isAllowedCropBlock(Block cropBlock) {
        return cropBlock != Blocks.f_50440_ && !(cropBlock instanceof DoublePlantBlock);
    }

    private void tickCropBlock(ServerLevel world, BlockPos cropPos, BlockState cropState, Block cropBlock, double distance) {
        distance -= (double)this.fullPotencyRange();
        distance = Math.max(1.0, distance);
        double distanceCoefficient = 1.0 - distance / (double)this.tileRange();
        world.m_186460_(cropPos, cropBlock, (int)(distanceCoefficient * (double)this.secondsBetweenGrowthTicks() * 20.0));
        cropBlock.m_213898_(cropState, world, cropPos, world.f_46441_);
        world.m_46796_(2005, cropPos, Math.max((int)((double)this.tileRange() - distance), 1));
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (entityIn instanceof Boat) {
            worldIn.m_46961_(pos, true);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        FluidState ifluidstate = worldIn.m_6425_(pos);
        return ifluidstate.m_76152_() == Fluids.f_76193_ || state.m_60767_() == Material.f_76276_;
    }
}

