/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.PriorityScreen;
import com.refinedmods.refinedstorage.screen.StorageScreenSynchronizationParameters;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.AccessTypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.WhitelistBlacklistSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class StorageScreen<T extends AbstractContainerMenu>
extends BaseScreen<T> {
    private static final int BAR_X = 8;
    private static final int BAR_Y = 54;
    private static final int BAR_WIDTH = 16;
    private static final int BAR_HEIGHT = 70;
    private final String texture;
    private final StorageScreenSynchronizationParameters parameters;
    private final Supplier<Long> storedSupplier;
    private final Supplier<Long> capacitySupplier;

    public StorageScreen(T containerMenu, Inventory inventory, Component title, String texture, StorageScreenSynchronizationParameters parameters, Supplier<Long> storedSupplier, Supplier<Long> capacitySupplier) {
        super(containerMenu, 176, 223, inventory, title);
        this.texture = texture;
        this.parameters = parameters;
        this.storedSupplier = storedSupplier;
        this.capacitySupplier = capacitySupplier;
    }

    @Override
    public void onPostInit(int x, int y) {
        if (this.parameters.getRedstoneModeParameter() != null) {
            this.addSideButton(new RedstoneModeSideButton(this, this.parameters.getRedstoneModeParameter()));
        }
        if (this.parameters.getTypeParameter() != null) {
            this.addSideButton(new TypeSideButton(this, this.parameters.getTypeParameter()));
        }
        if (this.parameters.getWhitelistBlacklistParameter() != null) {
            this.addSideButton(new WhitelistBlacklistSideButton(this, this.parameters.getWhitelistBlacklistParameter()));
        }
        if (this.parameters.getExactModeParameter() != null) {
            this.addSideButton(new ExactModeSideButton(this, this.parameters.getExactModeParameter()));
        }
        if (this.parameters.getAccessTypeParameter() != null) {
            this.addSideButton(new AccessTypeSideButton(this, this.parameters.getAccessTypeParameter()));
        }
        int buttonWidth = 10 + this.f_96547_.m_92895_(I18n.m_118938_((String)"misc.refinedstorage.priority", (Object[])new Object[0]));
        this.addButton(x + 169 - buttonWidth, y + 41, buttonWidth, 20, (Component)Component.m_237115_((String)"misc.refinedstorage.priority"), true, true, btn -> this.f_96541_.m_91152_((Screen)new PriorityScreen(this, this.parameters.getPriorityParameter(), this.inventory)));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", this.texture);
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int barHeightNew = this.capacitySupplier.get() < 0L ? 0 : (int)((float)this.storedSupplier.get().longValue() / (float)this.capacitySupplier.get().longValue() * 70.0f);
        this.m_93228_(poseStack, x + 8, y + 54 + 70 - barHeightNew, 179, 70 - barHeightNew, 16, barHeightNew);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        this.renderString(poseStack, 7, 42, this.capacitySupplier.get() == -1L ? I18n.m_118938_((String)"misc.refinedstorage.storage.stored_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().formatWithUnits(this.storedSupplier.get())}) : I18n.m_118938_((String)"misc.refinedstorage.storage.stored_capacity_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().formatWithUnits(this.storedSupplier.get()), API.instance().getQuantityFormatter().formatWithUnits(this.capacitySupplier.get())}));
        this.renderString(poseStack, 7, 129, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
        if (RenderUtils.inBounds(8, 54, 16, 70, mouseX, mouseY)) {
            int full = 0;
            if (this.capacitySupplier.get() >= 0L) {
                full = (int)((float)this.storedSupplier.get().longValue() / (float)this.capacitySupplier.get().longValue() * 100.0f);
            }
            this.renderTooltip(poseStack, mouseX, mouseY, (this.capacitySupplier.get() == -1L ? I18n.m_118938_((String)"misc.refinedstorage.storage.stored_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().format(this.storedSupplier.get())}) : I18n.m_118938_((String)"misc.refinedstorage.storage.stored_capacity_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().format(this.storedSupplier.get()), API.instance().getQuantityFormatter().format(this.capacitySupplier.get())})) + "\n" + ChatFormatting.GRAY + I18n.m_118938_((String)"misc.refinedstorage.storage.full", (Object[])new Object[]{full}));
        }
    }
}

