/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.mojang.math.Transformation;
import com.refinedmods.refinedstorage.render.model.AbstractUnbakedGeometry;
import com.refinedmods.refinedstorage.render.model.baked.PortableGridBakedModel;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class PortableGridUnbakedGeometry
extends AbstractUnbakedGeometry<PortableGridUnbakedGeometry> {
    private static final ResourceLocation BASE_CONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/portable_grid_connected");
    private static final ResourceLocation BASE_DISCONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/portable_grid_disconnected");
    private static final ResourceLocation DISK_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk");
    private static final ResourceLocation DISK_DISCONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk_disconnected");
    private static final ResourceLocation DISK_FULL_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk_full");
    private static final ResourceLocation DISK_NEAR_CAPACITY_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk_near_capacity");

    @Override
    protected Set<ResourceLocation> getModels() {
        return Set.of(BASE_CONNECTED_MODEL, BASE_DISCONNECTED_MODEL, DISK_MODEL, DISK_DISCONNECTED_MODEL, DISK_FULL_MODEL, DISK_NEAR_CAPACITY_MODEL);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        return new PortableGridBakedModel(Objects.requireNonNull(bakery.bake(BASE_CONNECTED_MODEL, modelState, spriteGetter)), this.getModelBakery(BASE_CONNECTED_MODEL, modelState, bakery, spriteGetter), this.getModelBakery(BASE_DISCONNECTED_MODEL, modelState, bakery, spriteGetter), this.getModelBakery(DISK_MODEL, modelState, bakery, spriteGetter), this.getModelBakery(DISK_NEAR_CAPACITY_MODEL, modelState, bakery, spriteGetter), this.getModelBakery(DISK_FULL_MODEL, modelState, bakery, spriteGetter), this.getModelBakery(DISK_DISCONNECTED_MODEL, modelState, bakery, spriteGetter), renderTypes);
    }

    private Function<Direction, BakedModel> getModelBakery(ResourceLocation id, ModelState state, ModelBakery bakery, Function<Material, TextureAtlasSprite> sg) {
        return direction -> {
            Transformation rotation = new Transformation(null, RenderUtils.getQuaternion(direction), null, null);
            SimpleModelState wrappedState = new SimpleModelState(rotation, state.m_7538_());
            return bakery.bake(id, (ModelState)wrappedState, sg);
        };
    }
}

