/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class GridItemPullMessage {
    private final UUID id;
    private final int flags;

    public GridItemPullMessage(UUID id, int flags) {
        this.id = id;
        this.flags = flags;
    }

    public static GridItemPullMessage decode(FriendlyByteBuf buf) {
        return new GridItemPullMessage(buf.m_130259_(), buf.readInt());
    }

    public static void encode(GridItemPullMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.id);
        buf.writeInt(message.flags);
    }

    public static void handle(GridItemPullMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                IGrid grid;
                AbstractContainerMenu container = player.f_36096_;
                if (container instanceof GridContainerMenu && (grid = ((GridContainerMenu)container).getGrid()).getItemHandler() != null) {
                    grid.getItemHandler().onExtract(player, message.id, -1, message.flags);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

