/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.item.FluidStoragePartItem;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FluidStorageDiskItem
extends Item
implements IStorageDiskProvider {
    private static final String NBT_ID = "Id";
    private final FluidStorageType type;

    public FluidStorageDiskItem(FluidStorageType type) {
        super(new Item.Properties().m_41491_(RS.CREATIVE_MODE_TAB).m_41487_(1));
        this.type = type;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!level.f_46443_ && !stack.m_41782_() && entity instanceof Player) {
            UUID id = UUID.randomUUID();
            API.instance().getStorageDiskManager((ServerLevel)level).set(id, API.instance().createDefaultFluidDisk((ServerLevel)level, this.getCapacity(stack), (Player)entity));
            API.instance().getStorageDiskManager((ServerLevel)level).markForSaving();
            this.setId(stack, id);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).m_6270_(Styles.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).m_6270_(Styles.GRAY));
                }
            }
            if (flag.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)id.toString()).m_6270_(Styles.GRAY));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        IStorageDisk disk;
        ItemStack diskStack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_() && this.type != FluidStorageType.CREATIVE && (disk = API.instance().getStorageDiskManager((ServerLevel)level).getByStack(diskStack)) != null && disk.getStored() == 0) {
            ItemStack storagePart = new ItemStack((ItemLike)FluidStoragePartItem.getByType(this.type), diskStack.m_41613_());
            if (!player.m_150109_().m_36054_(storagePart.m_41777_())) {
                Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)storagePart);
            }
            API.instance().getStorageDiskManager((ServerLevel)level).remove(this.getId(diskStack));
            API.instance().getStorageDiskManager((ServerLevel)level).markForSaving();
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack((ItemLike)RSItems.STORAGE_HOUSING.get()));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)diskStack);
    }

    public int getEntityLifespan(ItemStack stack, Level level) {
        return Integer.MAX_VALUE;
    }

    @Override
    public UUID getId(ItemStack disk) {
        return disk.m_41783_().m_128342_(NBT_ID);
    }

    @Override
    public void setId(ItemStack disk, UUID id) {
        disk.m_41751_(new CompoundTag());
        disk.m_41783_().m_128362_(NBT_ID, id);
    }

    @Override
    public boolean isValid(ItemStack disk) {
        return disk.m_41782_() && disk.m_41783_().m_128403_(NBT_ID);
    }

    @Override
    public int getCapacity(ItemStack disk) {
        return this.type.getCapacity();
    }

    @Override
    public StorageType getType() {
        return StorageType.FLUID;
    }
}

