/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.block.CableBlock;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.util.LevelUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class CoverItem
extends Item {
    public static final ItemStack HIDDEN_COVER_ALTERNATIVE = new ItemStack((ItemLike)Blocks.f_50222_);
    private static final String NBT_ITEM = "Item";

    public CoverItem() {
        super(new Item.Properties().m_41491_(RS.CREATIVE_MODE_TAB));
    }

    public static void setItem(ItemStack cover, ItemStack item) {
        if (!cover.m_41782_()) {
            cover.m_41751_(new CompoundTag());
        }
        ItemStack result = item.m_41777_();
        result.m_41764_(1);
        cover.m_41783_().m_128365_(NBT_ITEM, (Tag)result.serializeNBT());
    }

    @Nonnull
    public static ItemStack getItem(ItemStack cover) {
        if (!cover.m_41782_() || !cover.m_41783_().m_128441_(NBT_ITEM)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)cover.m_41783_().m_128469_(NBT_ITEM));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        ItemStack item = CoverItem.getItem(stack);
        if (!item.m_41619_()) {
            tooltip.add((Component)item.m_41720_().m_7626_(item).m_6881_().m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            if (!RS.CLIENT_CONFIG.getCover().showAllRecipesInJEI()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                CoverItem.setItem(stack, HIDDEN_COVER_ALTERNATIVE);
                items.add((Object)stack);
                return;
            }
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                Item item = Item.m_41439_((Block)block);
                if (item == Items.f_41852_) continue;
                NonNullList subBlocks = NonNullList.m_122779_();
                block.m_49811_(CreativeModeTab.f_40754_, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    if (!CoverManager.isValidCover(subBlock)) continue;
                    ItemStack stack = new ItemStack((ItemLike)this);
                    CoverItem.setItem(stack, subBlock);
                    items.add((Object)stack);
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Level level = context.m_43725_();
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!this.canPlaceOn(level, pos, facing)) {
            pos = pos.m_7494_();
            facing = Direction.DOWN;
            blockEntity = level.m_7702_(pos);
        }
        if (this.canPlaceOn(level, pos, facing)) {
            if (level.f_46443_) {
                level.getModelDataManager().requestRefresh(blockEntity);
                return InteractionResult.SUCCESS;
            }
            INetworkNode node = ((NetworkNodeBlockEntity)blockEntity).getNode();
            if (node.getNetwork() != null && !node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, context.m_43723_())) {
                LevelUtils.sendNoPermissionMessage(context.m_43723_());
                return InteractionResult.FAIL;
            }
            if (((ICoverable)((Object)node)).getCoverManager().setCover(facing, this.createCover(CoverItem.getItem(stack)))) {
                context.m_43723_().m_21120_(context.m_43724_()).m_41774_(1);
                LevelUtils.updateBlock(level, pos);
                API.instance().getNetworkNodeManager((ServerLevel)level).markForSaving();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private boolean canPlaceOn(Level level, BlockPos pos, Direction facing) {
        return level.m_7702_(pos) instanceof NetworkNodeBlockEntity && ((NetworkNodeBlockEntity)level.m_7702_(pos)).getNode() instanceof ICoverable && !CableBlock.hasVisualConnectionOnSide(level.m_8055_(pos), facing);
    }

    protected Cover createCover(ItemStack stack) {
        return new Cover(stack, CoverType.NORMAL);
    }
}

