/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.config.CoreClientConfig;
import cofh.core.item.ArmorItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.capability.FluxShieldedEnergyItemWrapper;
import cofh.redstonearsenal.item.IFluxItem;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluxArmorItem
extends ArmorItemCoFH
implements IFluxItem {
    protected int maxEnergy;
    protected int extract;
    protected int receive;

    public FluxArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(material, slot, builder);
        this.maxEnergy = maxEnergy;
        this.extract = maxTransfer;
        this.receive = maxTransfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluxShieldedEnergyItemWrapper(stack, this.getEnergyPerUse(true));
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.hasEnergy(stack, false) && slot == this.f_40377_ ? super.getAttributeModifiers(slot, stack) : ImmutableMultimap.of();
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        this.useEnergy(stack, Math.min(this.getEnergyStored(stack), amount * this.getEnergyPerUse(false)), (Entity)entity);
        return 0;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public boolean m_142522_(ItemStack stack) {
        return IFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

