/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage;

import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.RSAPIInject;
import com.refinedmods.refinedstorage.api.network.grid.IGridFactory;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.screen.KeyInputListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.gigabit101.rebornstorage.Constants;
import net.gigabit101.rebornstorage.RebornStorageConfig;
import net.gigabit101.rebornstorage.blockentities.BlockEntityMultiCrafter;
import net.gigabit101.rebornstorage.client.KeyBindings;
import net.gigabit101.rebornstorage.core.multiblock.events.MultiblockClientTickHandler;
import net.gigabit101.rebornstorage.core.multiblock.events.MultiblockEventHandler;
import net.gigabit101.rebornstorage.core.multiblock.events.MultiblockServerTickHandler;
import net.gigabit101.rebornstorage.grid.crafting.WirelessCraftingGridGridFactory;
import net.gigabit101.rebornstorage.init.ModBlocks;
import net.gigabit101.rebornstorage.init.ModContainers;
import net.gigabit101.rebornstorage.init.ModItems;
import net.gigabit101.rebornstorage.init.ModScreens;
import net.gigabit101.rebornstorage.multiblocks.MultiBlockCrafter;
import net.gigabit101.rebornstorage.nodes.AdvancedWirelessTransmitterNode;
import net.gigabit101.rebornstorage.nodes.CraftingNode;
import net.gigabit101.rebornstorage.packet.PacketChangeMode;
import net.gigabit101.rebornstorage.packet.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="rebornstorage")
public class RebornStorage {
    @RSAPIInject
    public static IRSAPI RSAPI;
    public static Logger logger;
    public static RebornStorage INSTANCE;

    public RebornStorage() {
        INSTANCE = this;
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RebornStorageConfig.loadConfig(RebornStorageConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("rebornstorage-common.toml"));
        ModItems.ITEMS.register(eventBus);
        ModBlocks.BLOCKS.register(eventBus);
        ModBlocks.TILES_ENTITIES.register(eventBus);
        ModContainers.CONTAINERS.register(eventBus);
        eventBus.addListener(this::preInit);
        eventBus.addListener(this::clientInit);
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().size(4).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("grid").icon(new ResourceLocation("rebornstorage", "items/grid")).size(1).build());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockServerTickHandler());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.addListener(this::keyRegisterEvent);
            MinecraftForge.EVENT_BUS.addListener(this::onKeyInput);
        });
    }

    @SubscribeEvent
    public void preInit(FMLCommonSetupEvent event) {
        PacketHandler.register();
        API.instance().getNetworkNodeRegistry().add(Constants.MULTI_BLOCK_ID, (tag, world, pos) -> {
            CraftingNode node = new CraftingNode(world, pos);
            StackUtils.readItems((BaseItemHandler)node.patterns, (int)0, (CompoundTag)tag);
            return node;
        });
        API.instance().getNetworkNodeRegistry().add(AdvancedWirelessTransmitterNode.ID, (tag, world, pos) -> RebornStorage.readAndReturn(tag, new AdvancedWirelessTransmitterNode(world, pos)));
        API.instance().getGridManager().add(WirelessCraftingGridGridFactory.ID, (IGridFactory)new WirelessCraftingGridGridFactory());
    }

    @SubscribeEvent
    public void clientInit(FMLClientSetupEvent event) {
        ModScreens.init();
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockClientTickHandler());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BLOCK_ADVANCED_WIRELESS_TRANSMITTER.get()), (RenderType)RenderType.m_110463_());
    }

    @SubscribeEvent
    public void keyRegisterEvent(RegisterKeyMappingsEvent event) {
        event.register(KeyBindings.OPEN_WIRELESS_CRAFTING_GRID);
        event.register(KeyBindings.MODE_SWITCH_WIRELESS_CRAFTING_GRID);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key e) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            if (KeyBindings.OPEN_WIRELESS_CRAFTING_GRID.m_90859_()) {
                KeyInputListener.findAndOpen((Item[])new Item[]{(Item)ModItems.WIRELESS_GRID.get(), (Item)ModItems.CREATIVE_WIRELESS_GRID.get()});
            }
            if (KeyBindings.MODE_SWITCH_WIRELESS_CRAFTING_GRID.m_90859_() && e.getAction() == 1) {
                PacketHandler.sendToServer(new PacketChangeMode());
            }
        }
    }

    public static MultiBlockCrafter getMultiBlock(Level world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof BlockEntityMultiCrafter) {
            return (MultiBlockCrafter)((BlockEntityMultiCrafter)tileEntity).getMultiblockController();
        }
        return null;
    }

    private static INetworkNode readAndReturn(CompoundTag tag, NetworkNode node) {
        node.read(tag);
        return node;
    }

    static {
        logger = LogManager.getLogger();
    }
}

