/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.common;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.roguelogix.phosphophyllite.repack.org.joml.Math;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.Queues;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.DynamicLight;
import net.roguelogix.quartz.internal.QuartzCore;

@NonnullDefault
public class LightEngine {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Long2ObjectOpenHashMap<SoftReference<Chunk>> liveChunks = new Long2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk getChunkFor(long longPos) {
        boolean readLocked = false;
        boolean writeLocked = false;
        try {
            readLocked = true;
            this.lock.readLock().lock();
            SoftReference chunkRef = (SoftReference)this.liveChunks.get(longPos);
            this.lock.readLock().unlock();
            readLocked = false;
            Chunk chunk = null;
            if (chunkRef != null) {
                chunk = (Chunk)chunkRef.get();
            }
            if (chunk == null) {
                chunk = new Chunk(longPos, lonk -> {
                    try {
                        this.lock.writeLock().lock();
                        this.liveChunks.remove(lonk);
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                });
                writeLocked = true;
                this.lock.writeLock().lock();
                this.liveChunks.put(longPos, new SoftReference<Chunk>(chunk));
                this.lock.writeLock().unlock();
                writeLocked = false;
            }
            Chunk chunk2 = chunk;
            return chunk2;
        }
        finally {
            if (writeLocked) {
                this.lock.writeLock().unlock();
            }
            if (readLocked) {
                this.lock.readLock().unlock();
            }
        }
    }

    public void update(BlockAndTintGetter blockAndTintGetter) {
        try {
            this.lock.readLock().lock();
            this.liveChunks.forEach((aLong, lightChunk) -> {
                Chunk chunk = (Chunk)lightChunk.get();
                if (chunk == null) {
                    return;
                }
                chunk.runUpdate(blockAndTintGetter);
            });
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sectionDirty(int x, int y, int z) {
        SoftReference chunkRef;
        long pos = SectionPos.m_123209_((int)x, (int)y, (int)z);
        try {
            this.lock.readLock().lock();
            chunkRef = (SoftReference)this.liveChunks.get(pos);
        }
        finally {
            this.lock.readLock().unlock();
        }
        Chunk chunk = null;
        if (chunkRef != null) {
            chunk = (Chunk)chunkRef.get();
        }
        if (chunk != null) {
            chunk.markDirty();
        }
    }

    public DynamicLight createLightForPos(Vector3ic pos, DynamicLight.Manager lightManager, DynamicLight.Type lightType) {
        long longPos = BlockPos.m_121882_((int)pos.x(), (int)pos.y(), (int)pos.z());
        longPos = SectionPos.m_123235_((long)longPos);
        Chunk chunk = this.getChunkFor(longPos);
        return chunk.createLightForPos(pos, lightManager, lightType);
    }

    private static class Chunk {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final ObjectArrayList<WeakReference<DynamicLight>> lights = new ObjectArrayList();
        private boolean dirty = true;

        public Chunk(long longPos, LongConsumer deathCallback) {
            QuartzCore.CLEANER.register(this, Chunk.createCleanerFunc(longPos, deathCallback));
        }

        private static Runnable createCleanerFunc(long pos, LongConsumer callback) {
            return () -> callback.accept(pos);
        }

        void markDirty() {
            this.dirty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runUpdate(BlockAndTintGetter blockAndTintGetter) {
            if (!this.dirty) {
                return;
            }
            this.dirty = false;
            boolean hasNullElement = false;
            try {
                this.lock.readLock().lock();
                for (WeakReference dynamicLightWeakReference : this.lights) {
                    DynamicLight light = (DynamicLight)dynamicLightWeakReference.get();
                    if (light == null) {
                        hasNullElement = true;
                        continue;
                    }
                    light.update(blockAndTintGetter);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (hasNullElement) {
                Queues.offThread.enqueue(() -> {
                    try {
                        this.lock.writeLock().lock();
                        for (int i = 0; i < this.lights.size(); ++i) {
                            WeakReference lightRef = (WeakReference)this.lights.get(i);
                            DynamicLight light = (DynamicLight)lightRef.get();
                            while (light == null) {
                                WeakReference end = (WeakReference)this.lights.pop();
                                DynamicLight endLight = (DynamicLight)end.get();
                                if (endLight == null) continue;
                                light = endLight;
                                this.lights.set(i, (Object)end);
                            }
                        }
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                }, new Event[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DynamicLight createLightForPos(Vector3ic pos, DynamicLight.Manager lightManager, DynamicLight.Type lightType) {
            DynamicLight light = lightManager.createLight(Chunk.createLightUpdateFunc(pos, lightType));
            WeakReference<DynamicLight> lightRef = new WeakReference<DynamicLight>(light);
            QuartzCore.CLEANER.register(light, () -> this.onLightDeleted(lightRef));
            try {
                this.lock.writeLock().lock();
                this.lights.add(lightRef);
                light.update((BlockAndTintGetter)Minecraft.m_91087_().f_91073_);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return light;
        }

        private void onLightDeleted(WeakReference<DynamicLight> lightRef) {
            try {
                this.lock.writeLock().lock();
                this.lights.remove(lightRef);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        static DynamicLight.UpdateFunc createLightUpdateFunc(Vector3ic pos, DynamicLight.Type lightType) {
            return switch (lightType) {
                default -> throw new IncompatibleClassChangeError();
                case DynamicLight.Type.SMOOTH -> Chunk.createSmoothLightUpdateFunc(pos);
                case DynamicLight.Type.FLAT -> Chunk.createFlatLightUpdateFunc(pos);
                case DynamicLight.Type.INTERNAL -> Chunk.createInternalLightUpdateFunc(pos);
            };
        }

        private static DynamicLight.UpdateFunc createSmoothLightUpdateFunc(Vector3ic pos) {
            int[][][][] lightVals = new int[3][3][3][2];
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos blockPos = new BlockPos(pos.x(), pos.y(), pos.z());
            return (light, blockAndTintGetter) -> {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            mutableBlockPos.m_122190_((Vec3i)blockPos);
                            mutableBlockPos.m_122184_(i, j, k);
                            if (blockAndTintGetter.m_8055_((BlockPos)mutableBlockPos).m_60831_((BlockGetter)blockAndTintGetter, (BlockPos)mutableBlockPos)) {
                                lightVals[i + 1][j + 1][k + 1][0] = -1;
                                lightVals[i + 1][j + 1][k + 1][1] = -1;
                                continue;
                            }
                            lightVals[i + 1][j + 1][k + 1][0] = blockAndTintGetter.m_45517_(LightLayer.SKY, (BlockPos)mutableBlockPos);
                            lightVals[i + 1][j + 1][k + 1][1] = blockAndTintGetter.m_45517_(LightLayer.BLOCK, (BlockPos)mutableBlockPos);
                        }
                    }
                }
                for (int x = 0; x < 2; ++x) {
                    for (int y = 0; y < 2; ++y) {
                        for (int z = 0; z < 2; ++z) {
                            for (int i = 0; i < 2; ++i) {
                                int skyLight = 0;
                                int defaultVal = lightVals[x + 1 - i][1][1][0];
                                defaultVal = defaultVal == -1 ? lightVals[1][1][1][0] : defaultVal;
                                int val = lightVals[x + 1 - i][y][z][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1 - i][y + 1][z][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1 - i][y][z + 1][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1 - i][y + 1][z + 1][0];
                                skyLight += val == -1 ? defaultVal : val;
                                int blockLight = 0;
                                defaultVal = lightVals[x + 1 - i][1][1][1];
                                defaultVal = defaultVal == -1 ? lightVals[1][1][1][1] : defaultVal;
                                val = lightVals[x + 1 - i][y][z][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1 - i][y + 1][z][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1 - i][y][z + 1][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1 - i][y + 1][z + 1][1];
                                byte AO = Chunk.AOMode(lightVals[x + 1 - i][y * 2][1][1] == -1, lightVals[x + 1 - i][y * 2][z * 2][1] == -1, lightVals[x + 1 - i][1][z * 2][1] == -1);
                                light.write(z * 4 + y * 2 + x, i * 3, (byte)skyLight, (byte)(blockLight += val == -1 ? defaultVal : val), AO);
                                skyLight = 0;
                                defaultVal = lightVals[1][y + 1 - i][1][0];
                                defaultVal = defaultVal == -1 ? lightVals[1][1][1][0] : defaultVal;
                                val = lightVals[x][y + 1 - i][z][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y + 1 - i][z][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x][y + 1 - i][z + 1][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y + 1 - i][z + 1][0];
                                skyLight += val == -1 ? defaultVal : val;
                                blockLight = 0;
                                defaultVal = lightVals[1][y + 1 - i][1][1];
                                defaultVal = defaultVal == -1 ? lightVals[1][1][1][1] : defaultVal;
                                val = lightVals[x][y + 1 - i][z][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y + 1 - i][z][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x][y + 1 - i][z + 1][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y + 1 - i][z + 1][1];
                                AO = Chunk.AOMode(lightVals[x * 2][y + 1 - i][1][1] == -1, lightVals[x * 2][y + 1 - i][z * 2][1] == -1, lightVals[1][y + 1 - i][z * 2][1] == -1);
                                light.write(z * 4 + y * 2 + x, 1 + i * 3, (byte)skyLight, (byte)(blockLight += val == -1 ? defaultVal : val), AO);
                                skyLight = 0;
                                defaultVal = lightVals[1][1][z + 1 - i][0];
                                defaultVal = defaultVal == -1 ? lightVals[1][1][1][0] : defaultVal;
                                val = lightVals[x][y][z + 1 - i][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y][z + 1 - i][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x][y + 1][z + 1 - i][0];
                                skyLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y + 1][z + 1 - i][0];
                                skyLight += val == -1 ? defaultVal : val;
                                blockLight = 0;
                                defaultVal = lightVals[1][1][z + 1 - i][1];
                                defaultVal = defaultVal == -1 ? lightVals[1][1][1][1] : defaultVal;
                                val = lightVals[x][y][z + 1 - i][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y][z + 1 - i][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x][y + 1][z + 1 - i][1];
                                blockLight += val == -1 ? defaultVal : val;
                                val = lightVals[x + 1][y + 1][z + 1 - i][1];
                                AO = Chunk.AOMode(lightVals[x * 2][1][z + 1 - i][1] == -1, lightVals[x * 2][y * 2][z + 1 - i][1] == -1, lightVals[1][y * 2][z + 1 - i][1] == -1);
                                light.write(z * 4 + y * 2 + x, 2 + i * 3, (byte)skyLight, (byte)(blockLight += val == -1 ? defaultVal : val), AO);
                            }
                        }
                    }
                }
            };
        }

        private static DynamicLight.UpdateFunc createFlatLightUpdateFunc(Vector3ic pos) {
            int[][][][] lightVals = new int[3][3][3][2];
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos blockPos = new BlockPos(pos.x(), pos.y(), pos.z());
            return (light, blockAndTintGetter) -> {
                int skyLight = blockAndTintGetter.m_45517_(LightLayer.SKY, blockPos);
                int blockLight = blockAndTintGetter.m_45517_(LightLayer.BLOCK, blockPos);
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            int absSum = Math.abs((int)i) + Math.abs((int)j) + Math.abs((int)k);
                            if (absSum > 1) continue;
                            mutableBlockPos.m_122190_((Vec3i)blockPos);
                            mutableBlockPos.m_122184_(i, j, k);
                            if (blockAndTintGetter.m_8055_((BlockPos)mutableBlockPos).m_60831_((BlockGetter)blockAndTintGetter, (BlockPos)mutableBlockPos)) {
                                lightVals[i + 1][j + 1][k + 1][0] = skyLight;
                                lightVals[i + 1][j + 1][k + 1][1] = blockLight;
                                continue;
                            }
                            lightVals[i + 1][j + 1][k + 1][0] = blockAndTintGetter.m_45517_(LightLayer.SKY, (BlockPos)mutableBlockPos);
                            lightVals[i + 1][j + 1][k + 1][1] = blockAndTintGetter.m_45517_(LightLayer.BLOCK, (BlockPos)mutableBlockPos);
                        }
                    }
                }
                for (int x = 0; x < 2; ++x) {
                    for (int y = 0; y < 2; ++y) {
                        for (int z = 0; z < 2; ++z) {
                            for (int i = 0; i < 2; ++i) {
                                int sky = lightVals[x + 1 - i][1][1][0];
                                int block = lightVals[x + 1 - i][1][1][1];
                                light.write(z * 4 + y * 2 + x, i * 3, (byte)sky, (byte)block, (byte)0);
                                sky = lightVals[1][y + 1 - i][1][0];
                                block = lightVals[1][y + 1 - i][1][1];
                                light.write(z * 4 + y * 2 + x, 1 + i * 3, (byte)sky, (byte)block, (byte)0);
                                sky = lightVals[1][1][z + 1 - i][0];
                                block = lightVals[1][1][z + 1 - i][1];
                                light.write(z * 4 + y * 2 + x, 2 + i * 3, (byte)sky, (byte)block, (byte)0);
                            }
                        }
                    }
                }
            };
        }

        private static DynamicLight.UpdateFunc createInternalLightUpdateFunc(Vector3ic pos) {
            BlockPos blockPos = new BlockPos(pos.x(), pos.y(), pos.z());
            return (light, blockAndTintGetter) -> {
                int skyLight = blockAndTintGetter.m_45517_(LightLayer.SKY, blockPos);
                int blockLight = blockAndTintGetter.m_45517_(LightLayer.BLOCK, blockPos);
                light.write((byte)(skyLight * 4), (byte)(blockLight * 4), (byte)0);
            };
        }

        private static byte AOMode(boolean sideA, boolean corner, boolean sideB) {
            if (sideA && sideB) {
                return 3;
            }
            if ((sideA || sideB) && corner) {
                return 2;
            }
            if (sideA || sideB || corner) {
                return 1;
            }
            return 0;
        }
    }
}

