/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.DrawInfo;
import net.roguelogix.quartz.internal.gl.GLBuffer;
import net.roguelogix.quartz.internal.gl.GLConfig;
import net.roguelogix.quartz.internal.gl.GLDrawBatch;
import net.roguelogix.quartz.internal.gl.GLMainProgram;
import net.roguelogix.quartz.internal.gl.GLRenderPass;
import org.lwjgl.opengl.ARBSeparateShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GLCapabilities;

@NonnullDefault
public class GLCore
extends QuartzCore {
    @Nonnull
    public static final GLCore INSTANCE = GLCore.attemptCreate();
    public static final boolean BASE_INSTANCE = GL.getCapabilities().GL_ARB_base_instance && GLConfig.INSTANCE.ALLOW_BASE_INSTANCE;
    public static final boolean ATTRIB_BINDING = GL.getCapabilities().GL_ARB_vertex_attrib_binding && GLConfig.INSTANCE.ALLOW_ATTRIB_BINDING;
    public static final boolean DRAW_INDIRECT = GL.getCapabilities().GL_ARB_draw_indirect && GLConfig.INSTANCE.ALLOW_DRAW_INDIRECT;
    public static final boolean MULTIDRAW_INDIRECT = DRAW_INDIRECT && GL.getCapabilities().GL_ARB_multi_draw_indirect && GLConfig.INSTANCE.ALLOW_MULTIDRAW_INDIRECT;
    public static final boolean SSBO = GL.getCapabilities().GL_ARB_shader_storage_buffer_object && GLConfig.INSTANCE.ALLOW_SSBO;
    public static final int SSBO_VERTEX_BLOCK_LIMIT = GL11.glGetInteger((int)37078);
    public static final int SSBO_FRAGMENT_BLOCK_LIMIT = GL11.glGetInteger((int)37082);
    public static final boolean MULTI_BIND = GL.getCapabilities().GL_ARB_multi_bind && GLConfig.INSTANCE.ALLOW_SSBO;
    public static final boolean DSA = GL.getCapabilities().GL_ARB_direct_state_access && GLConfig.INSTANCE.ALLOW_DSA;
    public GLMainProgram mainProgram = new GLMainProgram();
    public GLBuffer vertexBuffer;
    public GLBuffer elementBuffer;
    public GLBuffer.Allocation elementBufferAllocation;
    private final ObjectArrayList<WeakReference<GLDrawBatch>> batchers;
    public static final DrawInfo drawInfo = new DrawInfo();
    private long lastTimeNano;

    public GLCore() {
        this.vertexBuffer = this.meshManager.vertexBuffer.as(GLBuffer.class);
        this.elementBuffer = this.allocBuffer();
        this.elementBufferAllocation = this.elementBuffer.alloc(1);
        this.batchers = new ObjectArrayList();
        this.lastTimeNano = 0L;
    }

    @Nullable
    public static GLCore attemptCreate() {
        GLCapabilities capabilities = GL.getCapabilities();
        if (!capabilities.OpenGL32) {
            LOGGER.error("Unable to initialize Quartz GLCore due to missing GL 3.2 capabilities, this shouldn't be possible");
            return null;
        }
        if (!(capabilities.GL_ARB_separate_shader_objects && capabilities.GL_ARB_explicit_attrib_location && capabilities.GL_ARB_instanced_arrays)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unable to initialize Quartz GLCore due to missing GL extension, report this error!\n");
            builder.append("ISSUE URL -> https://github.com/BiggerSeries/Phosphophyllite/issues\n");
            builder.append("GL_ARB_separate_shader_objects : ").append(capabilities.GL_ARB_separate_shader_objects).append('\n');
            builder.append("GL_ARB_explicit_attrib_location : ").append(capabilities.GL_ARB_explicit_attrib_location).append('\n');
            builder.append("GL_ARB_instanced_arrays : ").append(capabilities.GL_ARB_instanced_arrays).append('\n');
            builder.append("GL_VENDOR : ").append(GL32C.glGetString((int)7936)).append('\n');
            builder.append("GL_RENDERER : ").append(GL32C.glGetString((int)7937)).append('\n');
            builder.append("GL_VERSION : ").append(GL32C.glGetString((int)7938)).append('\n');
            builder.append("GL_SHADING_LANGUAGE_VERSION : ").append(GL32C.glGetString((int)35724)).append('\n');
            int extensionCount = GL32C.glGetInteger((int)33309);
            builder.append("Supported OpenGL Extensions : ").append(extensionCount).append('\n');
            for (int i = 0; i < extensionCount; ++i) {
                builder.append(GL32C.glGetStringi((int)7939, (int)i)).append('\n');
            }
            Minecraft.m_91332_((CrashReport)new CrashReport("Quartz startup failed", (Throwable)new IllegalStateException(builder.toString())));
            return null;
        }
        LOGGER.info("Quartz initializing GLCore");
        return new GLCore();
    }

    @Override
    protected void startupInternal() {
    }

    @Override
    protected void shutdownInternal() {
        for (Field declaredField : GLCore.class.getDeclaredFields()) {
            declaredField.setAccessible(true);
            if (Modifier.isStatic(declaredField.getModifiers()) || !Object.class.isAssignableFrom(declaredField.getType())) continue;
            try {
                declaredField.set(this, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        do {
            System.gc();
        } while (deletionQueue.runAll());
        System.gc();
    }

    @Override
    protected void resourcesReloadedInternal() {
        this.mainProgram.reload();
        GLRenderPass.resourcesReloaded();
    }

    @Override
    public DrawBatch createDrawBatch() {
        GLDrawBatch batcher = new GLDrawBatch();
        this.batchers.add(new WeakReference<GLDrawBatch>(batcher));
        return batcher;
    }

    @Override
    public GLBuffer allocBuffer() {
        return new GLBuffer(false, 1);
    }

    public void ensureElementBufferLength(int faceCount) {
        if (this.elementBufferAllocation.size() < faceCount * 6) {
            int newFaceCount = Integer.highestOneBit(faceCount);
            if (newFaceCount < faceCount) {
                newFaceCount <<= 1;
            }
            this.elementBufferAllocation.allocator().free(this.elementBufferAllocation);
            this.elementBufferAllocation = this.elementBufferAllocation.allocator().alloc(newFaceCount * 24);
            ByteBuffer byteBuffer = this.elementBufferAllocation.buffer();
            int element = 0;
            for (int i = 0; i < newFaceCount; ++i) {
                byteBuffer.putInt(element);
                byteBuffer.putInt(element + 1);
                byteBuffer.putInt(element + 3);
                byteBuffer.putInt(element + 3);
                byteBuffer.putInt(element + 1);
                byteBuffer.putInt(element + 2);
                element += 4;
            }
            this.elementBufferAllocation.dirty();
            this.elementBuffer.flush();
        }
    }

    @Override
    public void frameStart(PoseStack pMatrixStack, float pPartialTicks, long pFinishTimeNano, boolean pDrawBlockOutline, Camera pActiveRenderInfo, GameRenderer pGameRenderer, LightTexture pLightmap, com.mojang.math.Matrix4f pProjection) {
        deletionQueue.runAll();
        long timeNanos = System.nanoTime();
        long deltaNano = timeNanos - this.lastTimeNano;
        this.lastTimeNano = timeNanos;
        if (this.lastTimeNano == 0L) {
            deltaNano = 0L;
        }
        this.vertexBuffer.flush();
        Vec3 playerPosition = pActiveRenderInfo.m_90583_();
        GLCore.drawInfo.playerPosition.set((int)playerPosition.f_82479_, (int)playerPosition.f_82480_, (int)playerPosition.f_82481_);
        GLCore.drawInfo.playerPositionNegative.set((Vector3ic)GLCore.drawInfo.playerPosition).negate();
        GLCore.drawInfo.playerSubBlock.set(playerPosition.f_82479_ - (double)((int)playerPosition.f_82479_), playerPosition.f_82480_ - (double)((int)playerPosition.f_82480_), playerPosition.f_82481_ - (double)((int)playerPosition.f_82481_));
        GLCore.drawInfo.playerSubBlockNegative.set((Vector3fc)GLCore.drawInfo.playerSubBlockNegative).negate();
        pProjection.m_27650_(GLCore.drawInfo.projectionMatrixFloatBuffer);
        GLCore.drawInfo.projectionMatrix.set(GLCore.drawInfo.projectionMatrixFloatBuffer);
        pMatrixStack.m_85850_().m_85861_().m_27650_(GLCore.drawInfo.projectionMatrixFloatBuffer);
        GLCore.drawInfo.projectionMatrix.mul((Matrix4fc)new Matrix4f().set(GLCore.drawInfo.projectionMatrixFloatBuffer));
        GLCore.drawInfo.projectionMatrix.get(GLCore.drawInfo.projectionMatrixFloatBuffer);
        GLCore.drawInfo.deltaNano = deltaNano;
        GLCore.drawInfo.partialTicks = pPartialTicks;
    }

    @Override
    public void lightUpdated() {
        this.lightEngine.update((BlockAndTintGetter)Minecraft.m_91087_().f_91073_);
    }

    @Override
    public void preTerrainSetup() {
        GLCore.drawInfo.fogStart = RenderSystem.m_157200_();
        GLCore.drawInfo.fogEnd = GLCore.drawInfo.fogStart == Float.MAX_VALUE ? Float.MAX_VALUE : RenderSystem.m_157199_();
        GLCore.drawInfo.fogColor.set(RenderSystem.m_157198_());
        this.mainProgram.setupDrawInfo(drawInfo);
        for (int i = 0; i < this.batchers.size(); ++i) {
            GLDrawBatch batch = (GLDrawBatch)((WeakReference)this.batchers.get(i)).get();
            if (batch == null) continue;
            batch.updateAndCull(drawInfo);
        }
    }

    @Override
    public void preOpaque() {
        GLDrawBatch batch;
        int i;
        GL32C.glEnable((int)2929);
        GL32C.glDepthFunc((int)515);
        BufferUploader.m_231208_();
        GL32C.glUseProgram((int)0);
        GL32C.glActiveTexture((int)33985);
        GL32C.glBindTexture((int)3553, (int)Minecraft.m_91087_().f_91063_.m_109154_().f_109870_.m_117963_());
        GL32C.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL32C.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL32C.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32C.glTexParameteri((int)3553, (int)10240, (int)9729);
        for (i = 0; i < this.batchers.size(); ++i) {
            batch = (GLDrawBatch)((WeakReference)this.batchers.get(i)).get();
            if (batch == null) continue;
            batch.drawOpaque();
        }
        for (i = 0; i < this.batchers.size(); ++i) {
            batch = (GLDrawBatch)((WeakReference)this.batchers.get(i)).get();
            if (batch == null) continue;
            batch.drawCutout();
        }
        GL32C.glBindVertexArray((int)0);
        ARBSeparateShaderObjects.glBindProgramPipeline((int)0);
        for (i = 0; i < 16; ++i) {
            GL32C.glActiveTexture((int)(33984 + i));
            GL32C.glBindTexture((int)35882, (int)0);
        }
        GL32C.glActiveTexture((int)33984);
        if (DRAW_INDIRECT) {
            GL32C.glBindBuffer((int)36671, (int)0);
        }
        GL32C.glBindBuffer((int)34962, (int)0);
    }

    @Override
    public void endOpaque() {
    }

    @Override
    public void endTranslucent() {
    }
}

