/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.api.client.widget;

import com.illusivesoulworks.polymorph.api.client.widget.OutputWidget;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.platform.Services;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SelectionWidget
extends GuiComponent
implements Widget,
GuiEventListener {
    private final Consumer<ResourceLocation> onSelect;
    private final AbstractContainerScreen<?> containerScreen;
    private final List<OutputWidget> outputWidgets = new ArrayList<OutputWidget>();
    private int xOffset;
    private int yOffset;
    private OutputWidget hoveredButton;
    private boolean active = false;
    private int x;
    private int y;
    private int lastX;
    private int lastY;

    public SelectionWidget(int x, int y, int xOffset, int yOffset, Consumer<ResourceLocation> onSelect, AbstractContainerScreen<?> containerScreen) {
        this.setPosition(x, y);
        this.onSelect = onSelect;
        this.containerScreen = containerScreen;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    public void setOffsets(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void highlightButton(ResourceLocation resourceLocation) {
        this.outputWidgets.forEach(widget -> widget.setHighlighted(widget.getResourceLocation().equals((Object)resourceLocation)));
    }

    private void updateButtonPositions() {
        int size = this.outputWidgets.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.outputWidgets.forEach(widget -> {
            widget.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<OutputWidget> getOutputWidgets() {
        return this.outputWidgets;
    }

    public void setRecipeList(Set<IRecipePair> recipeList) {
        this.outputWidgets.clear();
        recipeList.forEach(data -> {
            if (!data.getOutput().m_41619_()) {
                this.outputWidgets.add(new OutputWidget((IRecipePair)data));
            }
        });
        this.updateButtonPositions();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void renderTooltip(PoseStack poseStack, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && this.hoveredButton != null) {
            this.renderTooltip(this.hoveredButton.getOutput(), poseStack, this.hoveredButton.getTooltipText(mc.f_91080_), mouseX, mouseY);
        }
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive()) {
            int x = Services.CLIENT_PLATFORM.getScreenLeft(this.containerScreen) + this.xOffset;
            int y = Services.CLIENT_PLATFORM.getScreenTop(this.containerScreen) + this.yOffset;
            if (this.lastX != x || this.lastY != y) {
                this.setPosition(x, y);
                this.lastX = x;
                this.lastY = y;
            }
            this.hoveredButton = null;
            this.outputWidgets.forEach(button -> {
                button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                if (button.f_93624_ && button.m_198029_()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(poseStack, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isActive()) {
            for (OutputWidget widget : this.outputWidgets) {
                if (!widget.m_6375_(mouseX, mouseY, button)) continue;
                this.onSelect.accept(widget.getResourceLocation());
                return true;
            }
        }
        return false;
    }

    public void renderTooltip(ItemStack stack, PoseStack poseStack, List<Component> text, int mouseX, int mouseY) {
        Services.CLIENT_PLATFORM.renderTooltip(stack, poseStack, text, mouseX, mouseY, this.containerScreen, Minecraft.m_91087_().f_91062_, (x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> GuiComponent.m_93123_((Matrix4f)x$0, (BufferBuilder)x$1, (int)x$2, (int)x$3, (int)x$4, (int)x$5, (int)x$6, (int)x$7, (int)x$8));
    }

    public static interface GradientDrawer {
        public void fillGradient(Matrix4f var1, BufferBuilder var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }
}

