/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class EntityProvider {
    private static final ResourceLocation ID = PneumaticRegistry.RL("entity");

    public static class ComponentProvider
    implements IEntityComponentProvider {
        public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
            Entity entity;
            if (entityAccessor.getServerData().m_128441_("Pressure")) {
                float pressure = entityAccessor.getServerData().m_128457_("Pressure");
                iTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(pressure, 1)));
            }
            if (entityAccessor.getServerData().m_128441_("Temperature")) {
                iTooltip.add(HeatUtil.formatHeatString(entityAccessor.getServerData().m_128451_("Temperature")));
            }
            if ((entity = entityAccessor.getEntity()) instanceof ISemiBlock) {
                ISemiBlock semiBlock = (ISemiBlock)entity;
                semiBlock.addTooltip(arg_0 -> ((ITooltip)iTooltip).add(arg_0), entityAccessor.getPlayer(), entityAccessor.getServerData(), entityAccessor.getPlayer().m_6144_());
                BlockPos pos = semiBlock.getBlockPos();
                BlockState state = entityAccessor.getLevel().m_8055_(pos);
                iTooltip.add((Component)state.m_60734_().m_49954_().m_130940_(ChatFormatting.YELLOW));
            }
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }

    public static class DataProvider
    implements IServerDataProvider<Entity> {
        public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, Entity entity, boolean b) {
            entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> compoundTag.m_128350_("Pressure", h.getPressure()));
            entity.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(h -> compoundTag.m_128350_("Temperature", (float)h.getTemperatureAsInt()));
            if (entity instanceof ISemiBlock) {
                ISemiBlock s = (ISemiBlock)entity;
                s.serializeNBT(compoundTag);
            }
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }
}

