/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class AreaTypeWall
extends AreaType {
    public static final String ID = "wall";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;

    public AreaTypeWall() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.axis;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                Vec3 lineVec = new Vec3(0.0, (double)(p2.m_123342_() - p1.m_123342_()), (double)(p2.m_123343_() - p1.m_123343_())).m_82541_();
                lineVec = new Vec3(lineVec.f_82479_, lineVec.f_82480_ / 10.0, lineVec.f_82481_ / 10.0);
                double curY = (double)p1.m_123342_() + 0.5;
                double curZ = (double)p1.m_123343_() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.m_123342_() - p2.m_123342_(), 2.0) + Math.pow(p1.m_123343_() - p2.m_123343_(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curY += lineVec.f_82480_;
                    curZ += lineVec.f_82481_;
                    for (int z = minX; z <= maxX; ++z) {
                        areaAdder.accept(new BlockPos((double)z, curY, curZ));
                    }
                }
                break;
            }
            case Y: {
                Vec3 lineVec = new Vec3((double)(p2.m_123341_() - p1.m_123341_()), 0.0, (double)(p2.m_123343_() - p1.m_123343_())).m_82541_();
                lineVec = new Vec3(lineVec.f_82479_, lineVec.f_82480_ / 10.0, lineVec.f_82481_ / 10.0);
                double curX = (double)p1.m_123341_() + 0.5;
                double curZ = (double)p1.m_123343_() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.m_123341_() - p2.m_123341_(), 2.0) + Math.pow(p1.m_123343_() - p2.m_123343_(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.f_82479_;
                    curZ += lineVec.f_82481_;
                    for (int y = minY; y <= maxY; ++y) {
                        areaAdder.accept(new BlockPos(curX, (double)y, curZ));
                    }
                }
                break;
            }
            case Z: {
                Vec3 lineVec = new Vec3((double)(p2.m_123341_() - p1.m_123341_()), (double)(p2.m_123342_() - p1.m_123342_()), 0.0).m_82541_();
                lineVec = new Vec3(lineVec.f_82479_ / 10.0, lineVec.f_82480_ / 10.0, lineVec.f_82481_);
                double curX = (double)p1.m_123341_() + 0.5;
                double curY = (double)p1.m_123342_() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.m_123341_() - p2.m_123341_(), 2.0) + Math.pow(p1.m_123342_() - p2.m_123342_(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.f_82479_;
                    curY += lineVec.f_82480_;
                    for (int z = minZ; z <= maxZ; ++z) {
                        areaAdder.accept(new BlockPos(curX, curY, (double)z));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("axis", (byte)this.axis.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.m_128445_("axis")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.axis.ordinal());
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axis = AreaType.EnumAxis.values()[buf.readByte()];
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_WALL: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_WALL: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_WALL: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

