/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemFiltering;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.util.ChunkCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class ProgWidgetAreaItemBase
extends ProgWidget
implements IAreaProvider,
IEntityProvider,
IItemFiltering,
IVariableWidget {
    private List<BlockPos> areaListCache;
    private Set<BlockPos> areaSetCache;
    private AABB areaExtents;
    private Map<String, BlockPos> areaVariableStates;
    protected DroneAIManager aiManager;
    private boolean canCache = true;
    private EntityFilterPair<ProgWidgetAreaItemBase> entityFilters;

    public ProgWidgetAreaItemBase(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((ProgWidgetType)ModProgWidgets.AREA.get()), (Object)((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get()));
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        Set<BlockPos> areaSet;
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        if ((areaSet = this.getCachedAreaSet()).size() > (Integer)ConfigHelper.common().general.maxProgrammingArea.get()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.areaTooBig", ConfigHelper.common().general.maxProgrammingArea.get()));
        }
        EntityFilterPair.addErrors(this, curInfo);
    }

    public CollisionGetter getChunkCache(Level world) {
        AABB aabb = this.getAreaExtents();
        return new ChunkCache(world, new BlockPos(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_), new BlockPos(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_));
    }

    public AABB getAreaExtents() {
        if (this.areaExtents == null) {
            this.areaExtents = ProgWidgetAreaItemBase.calculateExtents(this.getCachedAreaSet());
        }
        return this.areaExtents;
    }

    private static AABB calculateExtents(Collection<BlockPos> areaSet) {
        if (areaSet.isEmpty()) {
            return new AABB(BlockPos.f_121853_, BlockPos.f_121853_);
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : areaSet) {
            minX = Math.min(minX, pos.m_123341_());
            maxX = Math.max(maxX, pos.m_123341_());
            minY = Math.min(minY, pos.m_123342_());
            maxY = Math.max(maxY, pos.m_123342_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        return new AABB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
    }

    public List<BlockPos> getCachedAreaList() {
        if (this.areaListCache != null) {
            if (!this.canCache || this.updateVariables()) {
                this.areaSetCache = new HashSet<BlockPos>(this.areaListCache.size());
                this.getArea(this.areaSetCache);
                this.areaExtents = null;
                this.areaListCache = new ArrayList<BlockPos>(this.areaSetCache.size());
                this.areaListCache.addAll(this.areaSetCache);
            }
        } else {
            this.areaExtents = null;
            this.areaSetCache = new HashSet<BlockPos>();
            this.getArea(this.areaSetCache);
            this.areaListCache = new ArrayList<BlockPos>(this.areaSetCache.size());
            this.areaListCache.addAll(this.areaSetCache);
            this.initializeVariableCache();
        }
        return this.areaListCache;
    }

    public Set<BlockPos> getCachedAreaSet() {
        this.getCachedAreaList();
        return this.areaSetCache;
    }

    protected synchronized void invalidateAreaCache() {
        this.areaListCache = null;
        this.areaSetCache = null;
        this.areaExtents = null;
    }

    private void initializeVariableCache() {
        this.areaVariableStates = new HashMap<String, BlockPos>();
        ProgWidgetArea whitelistWidget = (ProgWidgetArea)this.getConnectedParameters()[0];
        ProgWidgetArea blacklistWidget = (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().size()];
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            if (!widget.type.isDeterministic()) {
                this.canCache = false;
            }
            if (this.aiManager != null) {
                this.initVars(widget);
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            if (!widget.type.isDeterministic()) {
                this.canCache = false;
            }
            if (this.aiManager != null) {
                this.initVars(widget);
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
    }

    private void initVars(ProgWidgetArea widget) {
        for (int i = 0; i < 2; ++i) {
            String varName = widget.getVarName(i);
            if (varName.isEmpty()) continue;
            this.aiManager.getCoordinate(this.aiManager.getDrone().getOwnerUUID(), varName).ifPresent(pos -> this.areaVariableStates.put(varName, (BlockPos)pos));
        }
    }

    private boolean updateVariables() {
        int changed = 0;
        for (Map.Entry<String, BlockPos> entry : this.areaVariableStates.entrySet()) {
            if (!this.aiManager.getCoordinate(this.aiManager.getDrone().getOwnerUUID(), entry.getKey()).map(newValue -> {
                if (!newValue.equals(entry.getValue())) {
                    entry.setValue((BlockPos)newValue);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) continue;
            ++changed;
        }
        return changed > 0;
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetAreaItemBase.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().size()]);
    }

    public static void getArea(Set<BlockPos> area, ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget) {
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            widget.getArea(area);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        HashSet<BlockPos> blacklistedArea = new HashSet<BlockPos>();
        while (widget != null) {
            widget.getArea(blacklistedArea);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        area.removeAll(blacklistedArea);
    }

    @Override
    public boolean isItemValidForFilters(ItemStack item) {
        return this.isItemValidForFilters(item, null);
    }

    public boolean isItemValidForFilters(ItemStack item, BlockState blockState) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, ProgWidget.getConnectedWidgetList(this, 1, (ProgWidgetType)ModProgWidgets.ITEM_FILTER.get()), ProgWidget.getConnectedWidgetList(this, this.getParameters().size() + 1, (ProgWidgetType)ModProgWidgets.ITEM_FILTER.get()), blockState);
    }

    public boolean isItemFilterEmpty() {
        return this.getConnectedParameters()[1] == null && this.getConnectedParameters()[3] == null;
    }

    public List<Entity> getEntitiesInArea(Level world, Predicate<? super Entity> filter) {
        return ProgWidgetAreaItemBase.getEntitiesInArea((ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().size()], world, filter, null);
    }

    @Override
    public List<Entity> getValidEntities(Level world) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetAreaItemBase>(this);
        }
        return this.entityFilters.getValidEntities(world);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetAreaItemBase>(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }

    public static List<Entity> getEntitiesInArea(ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget, Level world, Predicate<? super Entity> whitelistPredicate, Predicate<? super Entity> blacklistPredicate) {
        if (whitelistWidget == null) {
            return new ArrayList<Entity>();
        }
        HashSet<Object> entities = new HashSet<Object>();
        ProgWidgetArea widget = whitelistWidget;
        if (whitelistPredicate == null) {
            whitelistPredicate = e -> true;
        }
        while (widget != null) {
            entities.addAll(widget.getEntitiesWithinArea(world, whitelistPredicate));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            widget.getEntitiesWithinArea(world, whitelistPredicate).forEach(entities::remove);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        if (blacklistPredicate != null) {
            entities.removeIf(blacklistPredicate);
        }
        return new ArrayList<Entity>(entities);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
    }
}

