/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.VacuumPumpMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class VacuumPumpBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<VacuumPumpBlockEntity>,
IManoMeasurable,
MenuProvider {
    @GuiSynced
    private final IAirHandlerMachine vacuumHandler;
    private final LazyOptional<IAirHandlerMachine> vacuumCap;
    public int rotation;
    public int oldRotation;
    private int turnTimer = -1;
    @DescSynced
    public boolean turning = false;
    private int rotationSpeed;
    @GuiSynced
    public final RedstoneController<VacuumPumpBlockEntity> rsController = new RedstoneController<VacuumPumpBlockEntity>(this);

    public VacuumPumpBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.VACUUM_PUMP.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
        this.vacuumHandler = new MachineAirHandler(PressureTier.TIER_ONE, 2000);
        this.vacuumCap = LazyOptional.of(() -> this.vacuumHandler);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY) {
            if (this.f_58857_ == null) {
                return LazyOptional.empty();
            }
            if (side == this.getVacuumSide()) {
                return this.vacuumCap.cast();
            }
            if (side != this.getInputSide() && side != null) {
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public Direction getInputSide() {
        return this.getVacuumSide().m_122424_();
    }

    public Direction getVacuumSide() {
        return this.getRotation();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        this.oldRotation = this.rotation;
        this.rotationSpeed = this.turning ? Math.min(this.rotationSpeed + 1, 20) : Math.max(this.rotationSpeed - 1, 0);
        this.rotation += this.rotationSpeed;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.turnTimer >= 0) {
            --this.turnTimer;
        }
        if (this.airHandler.getPressure() > 2.0f && this.vacuumHandler.getPressure() > -0.99f && this.rsController.shouldRun()) {
            if (this.turnTimer == -1) {
                this.turning = true;
            }
            this.airHandler.addAir((int)(-10.0f * this.getSpeedUsageMultiplierFromUpgrades()));
            this.vacuumHandler.addAir((int)(-4.0f * this.getSpeedMultiplierFromUpgrades()));
            this.turnTimer = 40;
        }
        if (this.turnTimer == 0) {
            this.turning = false;
        }
        this.airHandler.setSideLeaking(this.airHandler.getConnectedAirHandlers(this).isEmpty() ? this.getInputSide() : null);
        this.vacuumHandler.setSideLeaking(this.vacuumHandler.getConnectedAirHandlers(this).isEmpty() ? this.getVacuumSide() : null);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("vacuum", this.vacuumHandler.serializeNBT());
        tag.m_128379_("turning", this.turning);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.vacuumHandler.deserializeNBT((Tag)tag.m_128469_("vacuum"));
        this.turning = tag.m_128471_("turning");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        String input = PneumaticCraftUtils.roundNumberTo(this.airHandler.getPressure(), 1);
        String vac = PneumaticCraftUtils.roundNumberTo(this.vacuumHandler.getPressure(), 1);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.vacuum_pump.manometer", input, vac).m_130940_(ChatFormatting.GREEN));
    }

    @Override
    public RedstoneController<VacuumPumpBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new VacuumPumpMenu(i, playerInventory, this.m_58899_());
    }
}

