/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberValveBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberWallBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.PressureChamberInterfaceMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.util.AcceptabilityCache;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class PressureChamberInterfaceBlockEntity
extends PressureChamberWallBlockEntity
implements IRedstoneControl<PressureChamberInterfaceBlockEntity>,
MenuProvider {
    public static final int MAX_PROGRESS = 40;
    public static final int INVENTORY_SIZE = 1;
    private static final int MIN_SOUND_INTERVAL = 400;
    private static final AcceptabilityCache<Item> acceptedItemCache = new AcceptabilityCache();
    @DescSynced
    private final PressureChamberInterfaceHandler inventory = new PressureChamberInterfaceHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    @DescSynced
    private float doorSpeed = 1.0f;
    @DescSynced
    @LazySynced
    public float inputProgress;
    public float oldInputProgress;
    @DescSynced
    @LazySynced
    public float outputProgress;
    public float oldOutputProgress;
    @GuiSynced
    public InterfaceDirection interfaceMode = InterfaceDirection.NONE;
    @GuiSynced
    private boolean enoughAir = true;
    private boolean isOpeningInput;
    private boolean isOpeningOutput;
    private int soundTimer;
    @DescSynced
    private boolean shouldOpenInput;
    @DescSynced
    private boolean shouldOpenOutput;
    @GuiSynced
    public final RedstoneController<PressureChamberInterfaceBlockEntity> rsController = new RedstoneController<PressureChamberInterfaceBlockEntity>(this);
    private int inputTimeOut;
    private int oldItemCount;
    @GuiSynced
    public boolean exportAny;

    public PressureChamberInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.PRESSURE_CHAMBER_INTERFACE.get()), pos, state, 4);
    }

    public static void clearCachedItems() {
        acceptedItemCache.clear();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new PressureChamberInterfaceMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        boolean wasOpeningI = this.isOpeningInput;
        boolean wasOpeningO = this.isOpeningOutput;
        this.oldInputProgress = this.inputProgress;
        this.oldOutputProgress = this.outputProgress;
        PressureChamberValveBlockEntity core = this.getPrimaryValve();
        if (!this.nonNullLevel().f_46443_) {
            this.doorSpeed = this.getSpeedMultiplierFromUpgrades();
            int itemCount = this.inventory.getStackInSlot(0).m_41613_();
            if (this.oldItemCount != itemCount) {
                this.oldItemCount = itemCount;
                this.inputTimeOut = 0;
            }
            this.interfaceMode = this.getInterfaceMode(core);
            this.enoughAir = true;
            if (this.interfaceMode != InterfaceDirection.NONE) {
                if (!this.inventory.getStackInSlot(0).m_41619_() && ++this.inputTimeOut > 10) {
                    this.shouldOpenInput = false;
                    if (this.inputProgress == 0.0f) {
                        this.shouldOpenOutput = true;
                        if (this.outputProgress == 40.0f) {
                            if (this.interfaceMode == InterfaceDirection.IMPORT) {
                                this.outputInChamber();
                            } else {
                                this.exportToInventory();
                            }
                        }
                    }
                } else {
                    this.shouldOpenOutput = false;
                    if (this.outputProgress == 0.0f) {
                        this.shouldOpenInput = true;
                        if (this.interfaceMode == InterfaceDirection.EXPORT && this.inputProgress == 40.0f && this.rsController.shouldRun()) {
                            this.importFromChamber(core);
                        }
                    }
                }
            } else {
                this.shouldOpenInput = false;
                this.shouldOpenOutput = false;
            }
        }
        if (this.shouldOpenInput) {
            this.inputProgress = Math.min(this.inputProgress + this.doorSpeed, 40.0f);
            this.isOpeningInput = true;
        } else {
            this.inputProgress = Math.max(this.inputProgress - this.doorSpeed, 0.0f);
            this.isOpeningInput = false;
        }
        if (this.shouldOpenOutput) {
            this.outputProgress = Math.min(this.outputProgress + this.doorSpeed, 40.0f);
            this.isOpeningOutput = true;
        } else {
            this.outputProgress = Math.max(this.outputProgress - this.doorSpeed, 0.0f);
            this.isOpeningOutput = false;
        }
        if (this.nonNullLevel().f_46443_ && this.soundTimer++ >= 400 && (wasOpeningI != this.isOpeningInput || wasOpeningO != this.isOpeningOutput)) {
            this.nonNullLevel().m_7785_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, (SoundEvent)ModSounds.INTERFACE_DOOR.get(), SoundSource.BLOCKS, 0.5f, 1.0f, true);
            this.soundTimer = 0;
        }
    }

    public ItemStack getStackInInterface() {
        return this.inventory.getStackInSlot(0);
    }

    private void exportToInventory() {
        Direction facing = this.getRotation();
        BlockEntity te = this.getCachedNeighbor(facing);
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (te != null) {
            int count = stack.m_41613_();
            ItemStack leftoverStack = IOHelper.insert(te, stack.m_41777_(), facing.m_122424_(), false);
            stack.m_41774_(count - leftoverStack.m_41613_());
        } else if (this.getUpgrades((PNCUpgrade)ModUpgrades.DISPENSER.get()) > 0) {
            BlockPos pos = this.m_58899_().m_121945_(this.getRotation());
            PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.m_58904_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    private void importFromChamber(PressureChamberValveBlockEntity core) {
        CombinedInvWrapper chamberHandler = this.exportAny ? core.allItems : core.craftedItems;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack toTransferStack;
            ItemStack excess;
            IAirHandlerMachine coreAirHandler;
            int maxAllowedItems;
            ItemStack stackInInterface;
            ItemStack chamberStack = chamberHandler.getStackInSlot(i);
            if (chamberStack.m_41619_() || !(stackInInterface = this.inventory.getStackInSlot(0)).m_41619_() && !stackInInterface.m_41656_(chamberStack) || (maxAllowedItems = Math.abs((coreAirHandler = (IAirHandlerMachine)core.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).orElseThrow(RuntimeException::new)).getAir()) / 1000) <= 0) continue;
            maxAllowedItems = Math.min(maxAllowedItems, chamberStack.m_41741_() - stackInInterface.m_41613_());
            int transferredItems = Math.min(chamberStack.m_41613_(), maxAllowedItems);
            if (transferredItems <= 0 || (excess = this.inventory.insertItem(0, toTransferStack = chamberStack.m_41777_().m_41620_(transferredItems), true)).m_41613_() >= toTransferStack.m_41613_()) continue;
            transferredItems = toTransferStack.m_41613_() - excess.m_41613_();
            core.addAir((coreAirHandler.getAir() > 0 ? -1 : 1) * transferredItems * 1000);
            toTransferStack.m_41764_(transferredItems);
            this.inventory.insertItem(0, toTransferStack, false);
            chamberHandler.extractItem(i, transferredItems, false);
        }
    }

    private void outputInChamber() {
        PressureChamberValveBlockEntity valve = this.getPrimaryValve();
        if (valve != null) {
            ItemStack inputStack = this.inventory.getStackInSlot(0);
            IAirHandlerMachine valveAirHandler = (IAirHandlerMachine)valve.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).orElseThrow(RuntimeException::new);
            boolean bl = this.enoughAir = Math.abs(valveAirHandler.getAir()) > inputStack.m_41613_() * 1000;
            if (this.enoughAir) {
                ItemStack excess = valve.insertItemToChamber(inputStack);
                int inserted = inputStack.m_41613_() - excess.m_41613_();
                valve.addAir((valveAirHandler.getAir() > 0 ? -1 : 1) * inserted * 1000);
                this.inventory.setStackInSlot(0, excess);
            }
        }
    }

    private InterfaceDirection getInterfaceMode(PressureChamberValveBlockEntity core) {
        if (core != null) {
            boolean xMid = this.m_58899_().m_123341_() != core.multiBlockX && this.m_58899_().m_123341_() != core.multiBlockX + core.multiBlockSize - 1;
            boolean yMid = this.m_58899_().m_123342_() != core.multiBlockY && this.m_58899_().m_123342_() != core.multiBlockY + core.multiBlockSize - 1;
            boolean zMid = this.m_58899_().m_123343_() != core.multiBlockZ && this.m_58899_().m_123343_() != core.multiBlockZ + core.multiBlockSize - 1;
            Direction rotation = this.getRotation();
            if (xMid && yMid && rotation == Direction.NORTH || xMid && zMid && rotation == Direction.DOWN || yMid && zMid && rotation == Direction.WEST) {
                if (this.m_58899_().m_123341_() == core.multiBlockX || this.m_58899_().m_123342_() == core.multiBlockY || this.m_58899_().m_123343_() == core.multiBlockZ) {
                    return InterfaceDirection.EXPORT;
                }
                return InterfaceDirection.IMPORT;
            }
            if (xMid && yMid && rotation == Direction.SOUTH || xMid && zMid && rotation == Direction.UP || yMid && zMid && rotation == Direction.EAST) {
                if (this.m_58899_().m_123341_() == core.multiBlockX || this.m_58899_().m_123342_() == core.multiBlockY || this.m_58899_().m_123343_() == core.multiBlockZ) {
                    return InterfaceDirection.IMPORT;
                }
                return InterfaceDirection.EXPORT;
            }
        }
        return InterfaceDirection.NONE;
    }

    public boolean hasEnoughPressure() {
        return this.enoughAir;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
        this.outputProgress = tag.m_128457_("outputProgress");
        this.inputProgress = tag.m_128457_("inputProgress");
        this.interfaceMode = InterfaceDirection.values()[tag.m_128451_("interfaceMode")];
        this.exportAny = tag.m_128471_("exportAny");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
        tag.m_128350_("outputProgress", this.outputProgress);
        tag.m_128350_("inputProgress", this.inputProgress);
        tag.m_128405_("interfaceMode", this.interfaceMode.ordinal());
        tag.m_128379_("exportAny", this.exportAny);
    }

    @Override
    public boolean isGuiUseableByPlayer(Player player) {
        return this.nonNullLevel().m_7702_(this.m_58899_()) == this && player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("export_mode")) {
            this.exportAny = !this.exportAny;
            this.m_6596_();
        }
    }

    @Override
    public RedstoneController<PressureChamberInterfaceBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.invCap;
    }

    private class PressureChamberInterfaceHandler
    extends BaseItemStackHandler {
        PressureChamberInterfaceHandler() {
            super(PressureChamberInterfaceBlockEntity.this, 1);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return PressureChamberInterfaceBlockEntity.this.inputProgress == 40.0f && this.isValidItem(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return PressureChamberInterfaceBlockEntity.this.outputProgress == 40.0f ? super.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }

        private boolean isValidItem(ItemStack stack) {
            if (PressureChamberInterfaceBlockEntity.this.interfaceMode == InterfaceDirection.IMPORT) {
                return acceptedItemCache.isAcceptable(stack.m_41720_(), () -> ((PneumaticCraftRecipeType)ModRecipeTypes.PRESSURE_CHAMBER.get()).stream(PressureChamberInterfaceBlockEntity.this.f_58857_).anyMatch(recipe -> recipe.isValidInputItem(stack)));
            }
            return PressureChamberInterfaceBlockEntity.this.interfaceMode == InterfaceDirection.EXPORT;
        }
    }

    public static enum InterfaceDirection implements ITranslatableEnum
    {
        NONE,
        IMPORT,
        EXPORT;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.pressureChamberInterface.mode." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

