/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlock
extends AbstractCamouflageBlock
implements PneumaticCraftEntityBlock {
    public static final BooleanProperty CHARGE_PAD = BooleanProperty.m_61465_((String)"charge_pad");
    private static final VoxelShape CHARGING_STATION_N = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0), Block.m_49796_((double)5.0, (double)3.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0), Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.m_49796_((double)11.0, (double)7.25, (double)1.25, (double)12.5, (double)7.75, (double)1.75), Block.m_49796_((double)12.0, (double)3.25, (double)1.25, (double)12.5, (double)7.25, (double)1.75), Block.m_49796_((double)11.25, (double)3.25, (double)2.0, (double)11.75, (double)8.25, (double)2.5), Block.m_49796_((double)11.25, (double)3.25, (double)2.5, (double)11.75, (double)3.75, (double)3.0), Block.m_49796_((double)12.0, (double)3.25, (double)1.75, (double)12.5, (double)3.75, (double)3.25), Block.m_49796_((double)3.5, (double)7.25, (double)1.25, (double)5.0, (double)7.75, (double)1.75), Block.m_49796_((double)3.5, (double)3.25, (double)1.75, (double)4.0, (double)3.75, (double)3.25), Block.m_49796_((double)10.75, (double)8.25, (double)2.0, (double)11.75, (double)8.75, (double)2.5), Block.m_49796_((double)3.5, (double)3.25, (double)1.25, (double)4.0, (double)7.25, (double)1.75), Block.m_49796_((double)4.25, (double)8.25, (double)2.0, (double)5.25, (double)8.75, (double)2.5), Block.m_49796_((double)4.25, (double)3.25, (double)2.0, (double)4.75, (double)8.25, (double)2.5), Block.m_49796_((double)4.25, (double)3.25, (double)2.5, (double)4.75, (double)3.75, (double)3.0), Block.m_49796_((double)5.0, (double)1.0, (double)0.0, (double)11.0, (double)5.0, (double)1.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape CHARGING_STATION_E = VoxelShapeUtils.rotateY(CHARGING_STATION_N, 90);
    private static final VoxelShape CHARGING_STATION_S = VoxelShapeUtils.rotateY(CHARGING_STATION_E, 90);
    private static final VoxelShape CHARGING_STATION_W = VoxelShapeUtils.rotateY(CHARGING_STATION_S, 90);
    private static final VoxelShape CHARGING_PAD_N = Stream.of(Block.m_49796_((double)4.0, (double)15.05, (double)4.0, (double)12.0, (double)16.05, (double)12.0), Block.m_49796_((double)2.0, (double)2.0, (double)13.0, (double)3.0, (double)15.0, (double)14.0), Block.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)14.0, (double)15.0, (double)14.0), Block.m_49796_((double)13.0, (double)2.0, (double)2.0, (double)14.0, (double)15.0, (double)3.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)3.0, (double)15.0, (double)3.0), Block.m_49796_((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)13.0, (double)3.0, (double)3.0, (double)14.0, (double)13.0), Block.m_49796_((double)13.0, (double)13.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0), Block.m_49796_((double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)14.0, (double)14.0), Block.m_49796_((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)14.0, (double)3.0), Block.m_49796_((double)5.0, (double)12.75, (double)0.25, (double)11.0, (double)16.05, (double)4.0), Block.m_49796_((double)5.7, (double)11.2, (double)1.7, (double)6.3, (double)12.8, (double)2.3), Block.m_49796_((double)6.95, (double)11.2, (double)1.7, (double)7.55, (double)12.8, (double)2.3), Block.m_49796_((double)11.45, (double)9.2, (double)1.2, (double)12.05, (double)13.8, (double)1.8), Block.m_49796_((double)10.95, (double)9.2, (double)1.2, (double)11.55, (double)9.8, (double)1.8), Block.m_49796_((double)10.95, (double)13.2, (double)1.2, (double)11.55, (double)13.8, (double)1.8)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape CHARGING_PAD_E = VoxelShapeUtils.rotateY(CHARGING_PAD_N, 90);
    private static final VoxelShape CHARGING_PAD_S = VoxelShapeUtils.rotateY(CHARGING_PAD_E, 90);
    private static final VoxelShape CHARGING_PAD_W = VoxelShapeUtils.rotateY(CHARGING_PAD_S, 90);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_N = Shapes.m_83113_((VoxelShape)CHARGING_STATION_N, (VoxelShape)CHARGING_PAD_N, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_E = Shapes.m_83113_((VoxelShape)CHARGING_STATION_E, (VoxelShape)CHARGING_PAD_E, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_S = Shapes.m_83113_((VoxelShape)CHARGING_STATION_S, (VoxelShape)CHARGING_PAD_S, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_W = Shapes.m_83113_((VoxelShape)CHARGING_STATION_W, (VoxelShape)CHARGING_PAD_W, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_N_COLL = Shapes.m_83113_((VoxelShape)CHARGING_STATION_WITH_PAD_N, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_E_COLL = Shapes.m_83113_((VoxelShape)CHARGING_STATION_WITH_PAD_E, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_S_COLL = Shapes.m_83113_((VoxelShape)CHARGING_STATION_WITH_PAD_S, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_W_COLL = Shapes.m_83113_((VoxelShape)CHARGING_STATION_WITH_PAD_W, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
    private static final VoxelShape[] CHARGING_STATION = new VoxelShape[]{CHARGING_STATION_S, CHARGING_STATION_W, CHARGING_STATION_N, CHARGING_STATION_E};
    private static final VoxelShape[] CHARGING_STATION_WITH_PAD = new VoxelShape[]{CHARGING_STATION_WITH_PAD_S, CHARGING_STATION_WITH_PAD_W, CHARGING_STATION_WITH_PAD_N, CHARGING_STATION_WITH_PAD_E};
    private static final VoxelShape[] CHARGING_STATION_WITH_PAD_COLL = new VoxelShape[]{CHARGING_STATION_WITH_PAD_S_COLL, CHARGING_STATION_WITH_PAD_W_COLL, CHARGING_STATION_WITH_PAD_N_COLL, CHARGING_STATION_WITH_PAD_E_COLL};

    public ChargingStationBlock() {
        super(ModBlocks.defaultProps());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CHARGE_PAD, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CHARGE_PAD});
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction d = (Direction)state.m_61143_((Property)this.directionProperty());
        return (Boolean)state.m_61143_((Property)CHARGE_PAD) != false ? CHARGING_STATION_WITH_PAD[d.m_122416_()] : CHARGING_STATION[d.m_122416_()];
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        Direction d = (Direction)state.m_61143_((Property)this.directionProperty());
        return (Boolean)state.m_61143_((Property)CHARGE_PAD) != false ? CHARGING_STATION_WITH_PAD_COLL[d.m_122416_()] : CHARGING_STATION[d.m_122416_()];
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.m_141902_(pos, (BlockEntityType)ModBlockEntities.CHARGING_STATION.get()).map(teCS -> teCS.getRedstoneController().shouldEmit() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ChargingStationBlockEntity(pPos, pState);
    }

    public static class ItemBlockChargingStation
    extends BlockItem {
        public ItemBlockChargingStation(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        public String m_5671_(ItemStack stack) {
            CompoundTag tag = stack.m_41737_("BlockEntityTag");
            if (tag != null && tag.m_128471_("UpgradeOnly")) {
                return super.m_5671_(stack) + ".upgrade_only";
            }
            return super.m_5671_(stack);
        }
    }
}

