/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import me.desht.pneumaticcraft.api.client.assembly_machine.IAssemblyRenderOverriding;
import me.desht.pneumaticcraft.client.ClientRegistryImpl;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.AssemblyIOUnitBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;

public class AssemblyIOUnitRenderer
extends AbstractBlockEntityModelRenderer<AssemblyIOUnitBlockEntity> {
    private final ModelPart baseTurn;
    private final ModelPart baseTurn2;
    private final ModelPart armBase;
    private final ModelPart armMiddle;
    private final ModelPart clawBase;
    private final ModelPart clawAxle;
    private final ModelPart clawTurn;
    private final ModelPart claw1;
    private final ModelPart claw2;
    private static final float ITEM_SCALE = 0.5f;
    private static final String BASETURN = "baseTurn";
    private static final String BASETURN2 = "baseTurn2";
    private static final String ARMBASE = "armBase";
    private static final String ARMMIDDLE = "armMiddle";
    private static final String CLAWBASE = "clawBase";
    private static final String CLAWAXLE = "clawAxle";
    private static final String CLAWTURN = "clawTurn";
    private static final String CLAW1 = "claw1";
    private static final String CLAW2 = "claw2";

    public AssemblyIOUnitRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.m_173582_(PNCModelLayers.ASSEMBLY_IO_UNIT);
        this.baseTurn = root.m_171324_(BASETURN);
        this.baseTurn2 = root.m_171324_(BASETURN2);
        this.armBase = root.m_171324_(ARMBASE);
        this.armMiddle = root.m_171324_(ARMMIDDLE);
        this.clawBase = root.m_171324_(CLAWBASE);
        this.clawAxle = root.m_171324_(CLAWAXLE);
        this.clawTurn = root.m_171324_(CLAWTURN);
        this.claw1 = root.m_171324_(CLAW1);
        this.claw2 = root.m_171324_(CLAW2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BASETURN, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171534_("baseTurn_0", -1.0f, 0.0f, -1.0f, 9, 1, 9, 0, 0).m_171480_(), PartPose.m_171419_((float)-3.5f, (float)22.0f, (float)-3.5f));
        partdefinition.m_171599_(BASETURN2, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("baseTurn2_0", -2.0f, -0.5f, 0.5f, 2, 6, 3, new CubeDeformation(0.2f), 0, 30).m_171534_("baseTurn2_1", -2.0f, 3.75f, -2.0f, 2, 2, 8, 0, 10).m_171544_("baseTurn2_2", 4.0f, -0.5f, 0.5f, 2, 6, 3, new CubeDeformation(0.2f), 10, 30).m_171534_("baseTurn2_3", 4.0f, 3.75f, -2.0f, 2, 2, 8, 0, 20).m_171480_(), PartPose.m_171419_((float)-2.0f, (float)17.0f, (float)-2.0f));
        partdefinition.m_171599_(ARMBASE, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("armBase_0", 2.0f, 0.0f, 1.0f, 2, 2, 5, new CubeDeformation(0.3f), 0, 49).m_171534_("armBase_1", 1.5f, -0.5f, -0.5f, 3, 3, 3, 0, 43).m_171534_("armBase_2", 1.5f, -0.5f, 5.5f, 3, 3, 3, 12, 43).m_171534_("armBase_3", -1.5f, 0.0f, 0.0f, 9, 2, 2, 0, 39).m_171480_(), PartPose.m_171419_((float)-3.0f, (float)17.0f, (float)-1.0f));
        partdefinition.m_171599_(ARMMIDDLE, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171534_("armMiddle_0", 0.0f, 2.0f, 0.0f, 2, 13, 2, 20, 10).m_171544_("armMiddle_1", 0.0f, 0.0f, 0.0f, 2, 2, 2, new CubeDeformation(0.3f), 12, 24).m_171544_("armMiddle_2", 0.0f, 15.0f, 0.0f, 2, 2, 2, new CubeDeformation(0.3f), 0, 24).m_171534_("armMiddle_3", -0.5f, 15.0f, 0.0f, 3, 2, 2, 14, 52).m_171480_(), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)5.0f));
        partdefinition.m_171599_(CLAWBASE, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171534_("clawBase_0", -1.0f, -1.0f, 0.0f, 4, 4, 5, 46, 0).m_171480_(), PartPose.m_171419_((float)-1.0f, (float)2.0f, (float)4.5f));
        partdefinition.m_171599_(CLAWAXLE, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171534_("clawAxle_0", -0.5f, -0.5f, 0.0f, 2, 2, 1, 58, 9).m_171480_(), PartPose.m_171419_((float)-0.5f, (float)2.5f, (float)4.0f));
        partdefinition.m_171599_(CLAWTURN, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("clawTurn_0", 0.0f, -0.5f, 0.0f, 4, 3, 1, new CubeDeformation(0.1f), 54, 12).m_171480_(), PartPose.m_171419_((float)-2.0f, (float)2.0f, (float)3.0f));
        partdefinition.m_171599_(CLAW1, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("claw1_0", -0.1f, -0.5f, -1.35f, 1, 3, 2, new CubeDeformation(-0.1f), 52, 21).m_171534_("claw1_1", 0.25f, 0.0f, -1.35f, 1, 2, 2, 58, 21).m_171480_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)2.25f));
        partdefinition.m_171599_(CLAW2, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("claw2_0", 0.1f, -0.5f, -1.35f, 1, 3, 2, new CubeDeformation(-0.1f), 52, 16).m_171534_("claw2_1", -0.25f, 0.0f, -1.35f, 1, 2, 2, 58, 16).m_171480_(), PartPose.m_171419_((float)-1.0f, (float)2.0f, (float)2.25f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    void renderModel(AssemblyIOUnitBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IAssemblyRenderOverriding renderOverride;
        float[] angles = new float[5];
        for (int i = 0; i < 5; ++i) {
            angles[i] = te.oldAngles[i] + (te.angles[i] - te.oldAngles[i]) * partialTicks;
        }
        ItemStack heldStack = te.getPrimaryInventory().getStackInSlot(0);
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTexture(te)));
        Pair<IAssemblyRenderOverriding, Float> clawTranslation = this.getClawTranslation(Mth.m_14179_((float)partialTicks, (float)te.oldClawProgress, (float)te.clawProgress), heldStack);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(angles[0]));
        this.baseTurn.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.baseTurn2.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85837_(0.0, 1.125, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(angles[1]));
        matrixStackIn.m_85837_(0.0, -1.125, 0.0);
        this.armBase.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85837_(0.0, 1.125, 0.375);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(angles[2]));
        matrixStackIn.m_85837_(0.0, -1.125, -0.375);
        this.armMiddle.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85837_(0.0, 0.1875, 0.375);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(angles[3]));
        matrixStackIn.m_85837_(0.0, -0.1875, -0.375);
        this.clawBase.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85837_(0.0, 0.1875, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(angles[4]));
        matrixStackIn.m_85837_(0.0, -0.1875, 0.0);
        this.clawAxle.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.clawTurn.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_((double)((Float)clawTranslation.getRight()).floatValue(), 0.0, 0.0);
        this.claw1.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85837_((double)(-2.0f * ((Float)clawTranslation.getRight()).floatValue()), 0.0, 0.0);
        this.claw2.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
        if (!heldStack.m_41619_() && ((renderOverride = (IAssemblyRenderOverriding)clawTranslation.getLeft()) == null || renderOverride.applyRenderChangeIOUnit(matrixStackIn, heldStack))) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            double yOffset = heldStack.m_41720_() instanceof BlockItem ? 0.09375 : 0.03125;
            matrixStackIn.m_85837_(0.0, yOffset, -0.1875);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            BakedModel bakedModel = itemRenderer.m_174264_(heldStack, te.m_58904_(), null, 0);
            itemRenderer.m_115143_(heldStack, ItemTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedModel);
        }
    }

    private Pair<IAssemblyRenderOverriding, Float> getClawTranslation(float clawProgress, ItemStack heldStack) {
        IAssemblyRenderOverriding renderOverride = ClientRegistryImpl.getInstance().getAssemblyRenderOverride((ItemLike)heldStack.m_41720_());
        float clawTrans = !heldStack.m_41619_() ? (renderOverride != null ? renderOverride.getIOUnitClawShift(heldStack) : (heldStack.m_41720_() instanceof BlockItem ? 0.09375f - clawProgress * 0.1f / 16.0f : 0.09375f - clawProgress * 1.4f / 16.0f)) : 0.09375f - clawProgress * 1.5f / 16.0f;
        return Pair.of((Object)renderOverride, (Object)Float.valueOf(clawTrans));
    }

    private ResourceLocation getTexture(AssemblyIOUnitBlockEntity te) {
        return te != null && te.isImportUnit() ? Textures.MODEL_ASSEMBLY_IO_IMPORT : Textures.MODEL_ASSEMBLY_IO_EXPORT;
    }
}

