/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.common.entity.semiblock.SpawnerAgitatorEntity;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.BaseSpawnerAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTrackEntryMobSpawner
implements IBlockTrackEntry {
    public static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.spawner");

    @Override
    public boolean shouldTrackWithThisEntry(BlockGetter world, BlockPos pos, BlockState state, BlockEntity te) {
        return state.m_60734_() == Blocks.f_50085_;
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(BlockEntity te) {
        return te == null ? Collections.emptyList() : Collections.singletonList(te.m_58899_());
    }

    @Override
    public int spamThreshold() {
        return 10;
    }

    @Override
    public void addInformation(Level world, BlockPos pos, BlockEntity te, Direction face, List<Component> infoList) {
        if (te instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)te;
            BaseSpawner spawner = spawnerBlockEntity.m_59801_();
            Entity e = spawner.m_151314_(world);
            if (e == null) {
                infoList.add((Component)Component.m_237113_((String)"<ERROR> Missing entity?"));
                return;
            }
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.type", e.m_7755_().getString()));
            if (this.isNearPlayer(spawner, world, pos) || this.hasAgitator(world, pos)) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.time", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((BaseSpawnerAccess)spawner).getSpawnDelay(), false)));
            } else if (HackableMobSpawner.isHacked((BlockGetter)world, pos)) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.hacked", new Object[0]));
            } else {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.standby", new Object[0]));
            }
        }
    }

    private boolean isNearPlayer(BaseSpawner spawner, Level pLevel, BlockPos pPos) {
        return pLevel.m_45914_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, (double)((BaseSpawnerAccess)spawner).getRequiredPlayerRange());
    }

    private boolean hasAgitator(Level world, BlockPos pos) {
        return SemiblockTracker.getInstance().getSemiblock(world, pos) instanceof SpawnerAgitatorEntity;
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }
}

