/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WidgetAmadronOffer
extends AbstractWidget
implements ITooltipProvider {
    private final AmadronRecipe offer;
    private final List<AbstractWidget> subWidgets = new ArrayList<AbstractWidget>();
    private int shoppingAmount;
    private boolean canBuy;
    private final Rect2i[] tooltipRectangles = new Rect2i[2];
    private boolean renderBackground = true;

    public WidgetAmadronOffer(int x, int y, AmadronRecipe offer) {
        super(x, y, 73, 35, (Component)Component.m_237119_());
        this.offer = offer;
        offer.getInput().accept(itemStack -> this.subWidgets.add((AbstractWidget)new WidgetItemStack(x + 6, y + 13, (ItemStack)itemStack)), fluidStack -> this.subWidgets.add(new WidgetFluidStack(x + 6, y + 15, fluidStack.copy(), null)));
        offer.getOutput().accept(itemStack -> this.subWidgets.add((AbstractWidget)new WidgetItemStack(x + 51, y + 13, (ItemStack)itemStack)), fluidStack -> this.subWidgets.add(new WidgetFluidStack(x + 51, y + 15, fluidStack.copy(), null)));
        if (offer.isRemovableBy((Player)Minecraft.m_91087_().f_91074_)) {
            ArrayList<Component> l = new ArrayList<Component>(GuiUtils.xlateAndSplit("pneumaticcraft.gui.amadron.amadronWidget.sneakRightClickToRemove", new Object[0]));
            l.add((Component)Component.m_237119_());
            this.subWidgets.add((AbstractWidget)new WidgetButtonExtended(x + 57, y + 1, 11, 11, (Component)Component.m_237113_((String)(ChatFormatting.RED + "x")), b -> NetworkHandler.sendToServer(new PacketGuiButton("remove:" + offer.m_6423_()))).setTooltipText(l));
        }
        this.tooltipRectangles[0] = new Rect2i(x + 5, y + 14, 18, 18);
        this.tooltipRectangles[1] = new Rect2i(x + 50, y + 14, 18, 18);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.subWidgets.forEach(w -> w.m_6305_(matrixStack, mouseX, mouseY, partialTicks));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.subWidgets.stream().anyMatch(w -> w.m_6375_(mouseX, mouseY, button));
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            Object str;
            Font fr = Minecraft.m_91087_().f_91062_;
            if (this.renderBackground) {
                GuiUtils.bindTexture(Textures.WIDGET_AMADRON_OFFER);
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)256, (int)256);
            }
            FormattedCharSequence r = (FormattedCharSequence)fr.m_92923_((FormattedText)this.offer.getVendorName(), 73).get(0);
            fr.m_92877_(matrixStack, r, (float)(this.f_93620_ + 2), (float)(this.f_93621_ + 2), -16777216);
            if (this.shoppingAmount > 0) {
                str = Integer.toString(this.shoppingAmount);
                fr.m_92883_(matrixStack, (String)str, (float)(this.f_93620_ + 36) - (float)fr.m_92895_((String)str) / 2.0f, (float)(this.f_93621_ + (this.offer.getStock() >= 0 ? 15 : 20)), -16777216);
            }
            if (this.offer.getStock() >= 0) {
                str = ChatFormatting.DARK_BLUE.toString() + this.offer.getStock();
                fr.m_92883_(matrixStack, (String)str, (float)(this.f_93620_ + 36) - (float)fr.m_92895_((String)str) / 2.0f, (float)(this.f_93621_ + 25), -16777216);
            }
            boolean availableHere = this.offer.isUsableByPlayer(ClientUtils.getClientPlayer());
            if (this.offer.isLocationLimited()) {
                RenderSystem.m_69478_();
                RenderSystem.m_69405_((int)770, (int)771);
                GuiUtils.drawTexture(matrixStack, availableHere ? Textures.GUI_OK_LOCATION : Textures.GUI_BAD_LOCATION, this.f_93620_ + this.f_93618_ - 15, this.f_93621_ - 1);
                RenderSystem.m_69461_();
            }
            if (!this.canBuy || !availableHere) {
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-1065336768);
            }
        }
    }

    public WidgetAmadronOffer setDrawBackground(boolean drawBackground) {
        this.renderBackground = drawBackground;
        return this;
    }

    public WidgetAmadronOffer setAffordable(boolean canBuy) {
        this.canBuy = canBuy;
        return this;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shiftPressed) {
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.m_198029_() || !(widget instanceof ITooltipProvider)) continue;
            ITooltipProvider provider = (ITooltipProvider)widget;
            provider.addTooltip(mouseX, mouseY, curTip, shiftPressed);
        }
        boolean isInBounds = false;
        for (Rect2i rect : this.tooltipRectangles) {
            if (!rect.m_110087_((int)mouseX, (int)mouseY)) continue;
            isInBounds = true;
        }
        if (!isInBounds) {
            WidgetAmadronOffer.addTooltip(this.offer, curTip, this.shoppingAmount);
        }
    }

    public AmadronRecipe getOffer() {
        return this.offer;
    }

    public void setShoppingAmount(int amount) {
        this.shoppingAmount = amount;
    }

    public static void addTooltip(AmadronRecipe offer, List<Component> curTip, int shoppingAmount) {
        curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.vendor", offer.getVendorName().m_6881_().m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.YELLOW));
        curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.selling", Component.m_237113_((String)offer.getOutput().toString()).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.YELLOW));
        curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.buying", Component.m_237113_((String)offer.getInput().toString()).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.YELLOW));
        if (shoppingAmount >= 0) {
            if (offer.getStock() >= 0) {
                curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.stock", Component.m_237113_((String)Integer.toString(offer.getStock())).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA));
            }
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.inBasket", Component.m_237113_((String)Integer.toString(shoppingAmount)).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA));
        }
        if (!offer.isUsableByPlayer(ClientUtils.getClientPlayer())) {
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.unavailable", new Object[0]).m_130940_(ChatFormatting.RED));
        }
        offer.addAvailabilityData(ClientUtils.getClientPlayer(), curTip);
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            curTip.add((Component)Component.m_237113_((String)offer.m_6423_().toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    private static class WidgetItemStack
    extends WidgetButtonExtended {
        public WidgetItemStack(int startX, int startY, ItemStack stack) {
            super(startX, startY, 16, 16);
            this.setRenderStacks(stack);
            this.setTooltipText(stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL));
            this.setVisible(false);
            this.setRenderStackSize(true);
        }

        protected boolean m_7972_(int pButton) {
            return false;
        }
    }
}

