/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.worldgen.OilLakeFilter;
import me.desht.pneumaticcraft.datagen.ModAdvancementProvider;
import me.desht.pneumaticcraft.datagen.ModBiomeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModBlockTagsProvider;
import me.desht.pneumaticcraft.datagen.ModEntityTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModFluidTagsProvider;
import me.desht.pneumaticcraft.datagen.ModGLMProvider;
import me.desht.pneumaticcraft.datagen.ModItemTagsProvider;
import me.desht.pneumaticcraft.datagen.ModLootTablesProvider;
import me.desht.pneumaticcraft.datagen.ModPoiTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModRecipeProvider;
import me.desht.pneumaticcraft.datagen.ModStructureTagsProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private static final ResourceLocation OIL_LAKE_RL = PneumaticRegistry.RL("oil_lake");
    private static final ResourceLocation OIL_LAKE_SURFACE_RL = PneumaticRegistry.RL("oil_lake_surface");
    private static final ResourceLocation OIL_LAKE_UNDERGROUND_RL = PneumaticRegistry.RL("oil_lake_underground");

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        RegistryAccess.Writable registryAccess = RegistryAccess.m_206197_();
        RegistryOps registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        generator.m_236039_(event.includeServer(), (DataProvider)new ModRecipeProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModLootTablesProvider(generator));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(generator, existingFileHelper);
        generator.m_236039_(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.m_236039_(event.includeServer(), (DataProvider)new ModItemTagsProvider(generator, blockTagsProvider, existingFileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModFluidTagsProvider(generator, existingFileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModEntityTypeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModAdvancementProvider(generator, existingFileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModGLMProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModPoiTypeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModStructureTagsProvider(generator, event.getExistingFileHelper()));
        DataGenerators.oilLakeDatagen(event, generator, existingFileHelper, (RegistryOps<JsonElement>)registryOps);
    }

    private static void oilLakeDatagen(GatherDataEvent event, DataGenerator generator, ExistingFileHelper existingFileHelper, RegistryOps<JsonElement> registryOps) {
        ConfiguredFeature oilLakeCF = new ConfiguredFeature(Feature.f_65783_, (FeatureConfiguration)new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((LiquidBlock)ModBlocks.OIL.get()).m_49966_()), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_())));
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"pneumaticcraft", registryOps, (ResourceKey)Registry.f_122881_, Map.of(OIL_LAKE_RL, oilLakeCF)));
        ResourceKey oilLakeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)OIL_LAKE_RL);
        Holder oilLakeHolder = ((Registry)registryOps.m_206826_(Registry.f_122881_).orElseThrow()).m_214121_(oilLakeKey);
        PlacedFeature oilLakeSurface = new PlacedFeature(oilLakeHolder, (List)ImmutableList.of((Object)RarityFilter.m_191900_((int)25), (Object)InSquarePlacement.m_191715_(), (Object)PlacementUtils.f_195354_, (Object)BiomeFilter.m_191561_(), (Object)((Object)OilLakeFilter.oilLakeFilter())));
        PlacedFeature oilLakeUnderground = new PlacedFeature(oilLakeHolder, (List)ImmutableList.of((Object)RarityFilter.m_191900_((int)6), (Object)InSquarePlacement.m_191715_(), (Object)HeightRangePlacement.m_191683_((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158929_())), (Object)EnvironmentScanPlacement.m_191653_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.f_190393_), (BlockPredicate)BlockPredicate.m_190433_((Vec3i)new BlockPos(0, -5, 0))), (int)32), (Object)SurfaceRelativeThresholdFilter.m_191930_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, (int)Integer.MIN_VALUE, (int)-5), (Object)BiomeFilter.m_191561_(), (Object)((Object)OilLakeFilter.oilLakeFilter())));
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"pneumaticcraft", registryOps, (ResourceKey)Registry.f_194567_, Map.of(OIL_LAKE_SURFACE_RL, oilLakeSurface, OIL_LAKE_UNDERGROUND_RL, oilLakeUnderground)));
        ResourceKey oilLakeSurfaceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)OIL_LAKE_SURFACE_RL);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier surfaceModifier = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)((Registry)registryOps.m_206826_(Registry.f_122885_).orElseThrow()).m_203561_(PneumaticCraftTags.Biomes.OIL_LAKES_SURFACE), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{((Registry)registryOps.m_206826_(Registry.f_194567_).orElseThrow()).m_214121_(oilLakeSurfaceKey)}), GenerationStep.Decoration.LAKES);
        ResourceKey oilLakeUndergroundKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)OIL_LAKE_UNDERGROUND_RL);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier undergroundModifier = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)((Registry)registryOps.m_206826_(Registry.f_122885_).orElseThrow()).m_203561_(PneumaticCraftTags.Biomes.OIL_LAKES_UNDERGROUND), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{((Registry)registryOps.m_206826_(Registry.f_194567_).orElseThrow()).m_214121_(oilLakeUndergroundKey)}), GenerationStep.Decoration.LAKES);
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"pneumaticcraft", registryOps, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, Map.of(OIL_LAKE_SURFACE_RL, surfaceModifier, OIL_LAKE_UNDERGROUND_RL, undergroundModifier)));
    }
}

