/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.MekanismIntegration;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import mekanism.api.radiation.capability.IRadiationShielding;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class MekRadShieldProvider
implements ICapabilityProvider {
    private final IRadiationShielding impl;
    private final LazyOptional<IRadiationShielding> lazy;

    public MekRadShieldProvider(ItemStack stack, EquipmentSlot slot) {
        this.impl = new PneumaticArmorRadiationShield(stack, slot);
        this.lazy = LazyOptional.of(() -> this.impl);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return MekanismIntegration.CAPABILITY_RADIATION_SHIELDING.orEmpty(cap, this.lazy);
    }

    public record PneumaticArmorRadiationShield(ItemStack stack, EquipmentSlot slot) implements IRadiationShielding
    {
        public double getRadiationShielding() {
            boolean upgrade;
            boolean bl = upgrade = UpgradableItemUtils.getUpgradeCount(this.stack, (PNCUpgrade)ModUpgrades.RADIATION_SHIELDING.get()) > 0;
            if (!upgrade) {
                return 0.0;
            }
            return switch (this.slot) {
                case EquipmentSlot.HEAD -> 0.25;
                case EquipmentSlot.CHEST -> 0.4;
                case EquipmentSlot.LEGS -> 0.2;
                case EquipmentSlot.FEET -> 0.15;
                default -> 0.0;
            };
        }
    }
}

