/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.AmadronAddTradeScreen;
import me.desht.pneumaticcraft.client.gui.AssemblyControllerScreen;
import me.desht.pneumaticcraft.client.gui.FluidMixerScreen;
import me.desht.pneumaticcraft.client.gui.PressureChamberScreen;
import me.desht.pneumaticcraft.client.gui.RefineryControllerScreen;
import me.desht.pneumaticcraft.client.gui.ThermopneumaticProcessingPlantScreen;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetItemFilterScreen;
import me.desht.pneumaticcraft.client.gui.semiblock.AbstractLogisticsScreen;
import me.desht.pneumaticcraft.common.block.entity.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.jei.CustomRecipeClickArea;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIAmadronTradeCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIAssemblyControllerCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIBlockHeatPropertiesCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIEtchingTankCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIExplosionCraftingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIFluidMixerCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIHeatFrameCoolingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIMemoryEssenceCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlasticSolidifyingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPressureChamberRecipeCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIRefineryCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEISpawnerExtractionCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIThermopneumaticProcessingPlantCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIUVLightBoxCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIYeastCraftingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.AmadronAddTradeGhost;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.LogisticsFilterGhost;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.ProgWidgetItemFilterGhost;
import me.desht.pneumaticcraft.common.thirdparty.jei.transfer.ProgrammerTransferHandler;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    static IJeiHelpers jeiHelpers;
    static IRecipeManager recipeManager;
    static IRecipesGui recipesGui;

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            if (!(item.get() instanceof PressurizableItem)) continue;
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)item.get()), (s, ctx) -> s.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h2 -> String.valueOf(h2.getPressure())).orElse(""));
        }
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.EMPTY_PCB.get()), (s, ctx) -> String.valueOf(UVLightBoxBlockEntity.getExposureProgress(s)));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIPressureChamberRecipeCategory(), new JEIAssemblyControllerCategory(), new JEIThermopneumaticProcessingPlantCategory(), new JEIRefineryCategory(), new JEIFluidMixerCategory(), new JEIUVLightBoxCategory(), new JEIAmadronTradeCategory(), new JEIHeatFrameCoolingCategory(), new JEIEtchingTankCategory(), new JEISpawnerExtractionCategory(), new JEIBlockHeatPropertiesCategory(), new JEIMemoryEssenceCategory(), new JEIExplosionCraftingCategory()});
        if (((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new JEIPlasticSolidifyingCategory()});
        }
        if (((Boolean)ConfigHelper.common().recipes.inWorldYeastCrafting.get()).booleanValue()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new JEIYeastCraftingCategory()});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.PRESSURE_CHAMBER.get(), RecipeTypes.PRESSURE_CHAMBER);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.HEAT_FRAME_COOLING.get(), RecipeTypes.HEAT_FRAME_COOLING);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.REFINERY.get(), RecipeTypes.REFINERY);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.THERMO_PLANT.get(), RecipeTypes.THERMO_PLANT);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_LASER.get(), RecipeTypes.ASSEMBLY);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL.get(), RecipeTypes.ASSEMBLY);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL_LASER.get(), RecipeTypes.ASSEMBLY);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.AMADRON.get(), RecipeTypes.AMADRON_TRADE);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.FLUID_MIXER.get(), RecipeTypes.FLUID_MIXER);
        this.addRecipeType(registration, (PneumaticCraftRecipeType)ModRecipeTypes.EXPLOSION_CRAFTING.get(), RecipeTypes.EXPLOSION_CRAFTING);
        registration.addRecipes(RecipeTypes.UV_LIGHT_BOX, JEIUVLightBoxCategory.getAllRecipes());
        registration.addRecipes(RecipeTypes.ETCHING_TANK, JEIEtchingTankCategory.getAllRecipes());
        registration.addRecipes(RecipeTypes.SPAWNER_EXTRACTION, JEISpawnerExtractionCategory.getAllRecipes());
        registration.addRecipes(RecipeTypes.MEMORY_ESSENCE, JEIMemoryEssenceCategory.getAllRecipes());
        if (((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue()) {
            registration.addRecipes(RecipeTypes.PLASTIC_SOLIDIFYING, JEIPlasticSolidifyingCategory.getAllRecipes());
        }
        if (((Boolean)ConfigHelper.common().recipes.inWorldYeastCrafting.get()).booleanValue()) {
            registration.addRecipes(RecipeTypes.YEAST_CRAFTING, JEIYeastCraftingCategory.getAllRecipes());
        }
        registration.addRecipes(RecipeTypes.HEAT_PROPERTIES, JEIBlockHeatPropertiesCategory.getAllRecipes());
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            this.addStackInfo(registration, new ItemStack((ItemLike)item.get()));
        }
    }

    private <T extends PneumaticCraftRecipe> void addRecipeType(IRecipeRegistration registration, PneumaticCraftRecipeType<T> type, RecipeType<T> recipeType) {
        registration.addRecipes(recipeType, (List)ImmutableList.copyOf(type.getRecipes((Level)Minecraft.m_91087_().f_91073_).values()));
    }

    private void addStackInfo(IRecipeRegistration registry, ItemStack stack) {
        String k = ICustomTooltipName.getTranslationKey(stack, false);
        if (I18n.m_118936_((String)k)) {
            for (String s : StringUtils.splitByWholeSeparator((String)I18n.m_118938_((String)k, (Object[])new Object[0]), (String)"${br}")) {
                registry.addIngredientInfo((Object)stack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237113_((String)s)});
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.AMADRON_TABLET.get()), new RecipeType[]{RecipeTypes.AMADRON_TRADE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ASSEMBLY_CONTROLLER.get()), new RecipeType[]{RecipeTypes.ASSEMBLY});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get()), new RecipeType[]{RecipeTypes.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_VALVE.get()), new RecipeType[]{RecipeTypes.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()), new RecipeType[]{RecipeTypes.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_GLASS.get()), new RecipeType[]{RecipeTypes.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.REFINERY.get()), new RecipeType[]{RecipeTypes.REFINERY});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.REFINERY_OUTPUT.get()), new RecipeType[]{RecipeTypes.REFINERY});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()), new RecipeType[]{RecipeTypes.THERMO_PLANT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.UV_LIGHT_BOX.get()), new RecipeType[]{RecipeTypes.UV_LIGHT_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.HEAT_FRAME.get()), new RecipeType[]{RecipeTypes.HEAT_FRAME_COOLING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ETCHING_TANK.get()), new RecipeType[]{RecipeTypes.ETCHING_TANK});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FLUID_MIXER.get()), new RecipeType[]{RecipeTypes.FLUID_MIXER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SPAWNER_EXTRACTOR.get()), new RecipeType[]{RecipeTypes.SPAWNER_EXTRACTION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HEAT_PIPE.get()), new RecipeType[]{RecipeTypes.HEAT_PROPERTIES});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MEMORY_ESSENCE_BUCKET.get()), new RecipeType[]{RecipeTypes.MEMORY_ESSENCE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50077_), new RecipeType[]{RecipeTypes.EXPLOSION_CRAFTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AssemblyControllerScreen.class, 110, 10, 50, 50, new RecipeType[]{RecipeTypes.ASSEMBLY});
        registration.addRecipeClickArea(PressureChamberScreen.class, 100, 7, 60, 60, new RecipeType[]{RecipeTypes.PRESSURE_CHAMBER});
        CustomRecipeClickArea.add(registration, RefineryControllerScreen.class, 47, 33, 27, 47, RecipeTypes.REFINERY);
        CustomRecipeClickArea.add(registration, ThermopneumaticProcessingPlantScreen.class, 30, 36, 48, 30, RecipeTypes.THERMO_PLANT);
        CustomRecipeClickArea.add(registration, FluidMixerScreen.class, 50, 40, 47, 24, RecipeTypes.FLUID_MIXER);
        registration.addGenericGuiContainerHandler(AbstractPneumaticCraftContainerScreen.class, (IGuiContainerHandler)new GuiTabHandler());
        registration.addGuiScreenHandler(ProgWidgetItemFilterScreen.class, Helpers::getGuiProperties);
        registration.addGhostIngredientHandler(AmadronAddTradeScreen.class, (IGhostIngredientHandler)new AmadronAddTradeGhost());
        registration.addGhostIngredientHandler(AbstractLogisticsScreen.class, new LogisticsFilterGhost());
        registration.addGhostIngredientHandler(ProgWidgetItemFilterScreen.class, (IGhostIngredientHandler)new ProgWidgetItemFilterGhost());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeManager = jeiRuntime.getRecipeManager();
        recipesGui = jeiRuntime.getRecipesGui();
        MinecraftForge.EVENT_BUS.register(ProgrammerTransferHandler.Listener.class);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new ProgrammerTransferHandler(registration.getTransferHelper()));
    }

    public ResourceLocation getPluginUid() {
        return PneumaticRegistry.RL("default");
    }

    public static class GuiTabHandler
    implements IGuiContainerHandler<AbstractPneumaticCraftContainerScreen<?, ?>> {
        public List<Rect2i> getGuiExtraAreas(AbstractPneumaticCraftContainerScreen<?, ?> containerScreen) {
            return containerScreen.getTabRectangles();
        }
    }
}

