/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAmadronOffer;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class JEIAmadronTradeCategory
extends AbstractPNCCategory<AmadronRecipe> {
    private final IDrawable limitedIcon = JEIAmadronTradeCategory.guiHelper().drawableBuilder(Textures.GUI_OK_LOCATION, 0, 0, 16, 16).setTextureSize(16, 16).build();

    JEIAmadronTradeCategory() {
        super(RecipeTypes.AMADRON_TRADE, (Component)PneumaticCraftUtils.xlate(((AmadronTabletItem)ModItems.AMADRON_TABLET.get()).m_5524_(), new Object[0]), (IDrawable)JEIAmadronTradeCategory.guiHelper().createDrawable(Textures.WIDGET_AMADRON_OFFER, 0, 0, 73, 35), JEIAmadronTradeCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.AMADRON_TABLET.get())));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AmadronRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 6, 15);
        recipe.getInput().accept(arg_0 -> ((IRecipeSlotBuilder)inputSlot).addItemStack(arg_0), fluidStack -> ((IRecipeSlotBuilder)inputSlot.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, fluidStack)).setOverlay((IDrawable)new FluidTextOverlay((FluidStack)fluidStack), 0, 0));
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 51, 15);
        recipe.getOutput().accept(arg_0 -> ((IRecipeSlotBuilder)outputSlot).addItemStack(arg_0), fluidStack -> ((IRecipeSlotBuilder)outputSlot.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, fluidStack)).setOverlay((IDrawable)new FluidTextOverlay((FluidStack)fluidStack), 0, 0));
    }

    public void draw(AmadronRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        Font fr = Minecraft.m_91087_().f_91062_;
        int x = (this.getBackground().getWidth() - fr.m_92852_((FormattedText)recipe.getVendorName())) / 2;
        if (recipe.isLocationLimited()) {
            this.limitedIcon.draw(matrixStack, 60, -4);
        }
        fr.m_92889_(matrixStack, recipe.getVendorName(), (float)x, 3.0f, -12566464);
    }

    public List<Component> getTooltipStrings(AmadronRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> res = new ArrayList<Component>();
        if (mouseX >= 22.0 && mouseX <= 51.0) {
            WidgetAmadronOffer.addTooltip(recipe, res, -1);
        }
        return res;
    }

    private static class FluidTextOverlay
    implements IDrawable {
        private final String text;

        FluidTextOverlay(FluidStack stack) {
            this.text = stack.getAmount() / 1000 + "B";
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(PoseStack matrixStack, int x, int y) {
            Font fr = Minecraft.m_91087_().f_91062_;
            float f = x + this.getWidth() - fr.m_92895_(this.text);
            int n = y + this.getHeight();
            Objects.requireNonNull(fr);
            fr.m_92750_(matrixStack, this.text, f, (float)(n - 9), -1);
        }
    }
}

