/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;

public class HackHandler
extends BaseArmorUpgradeHandler<HackData> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("hacking");

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{(PNCUpgrade)ModUpgrades.SECURITY.get()};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    @Override
    public Supplier<HackData> extensionData() {
        return HackData::new;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            commonArmorHandler.getExtensionData(this).tickServerSide(sp);
        }
    }

    public static class HackData
    implements IArmorExtensionData {
        private int hackTime;
        private WorldAndCoord hackedBlockPos;
        private Entity hackedEntity;

        private void tickServerSide(ServerPlayer player) {
            if (this.hackedBlockPos != null) {
                this.tickBlockHack(player);
            } else if (this.hackedEntity != null) {
                this.tickEntityHack(player);
            }
        }

        private void tickBlockHack(ServerPlayer player) {
            IHackableBlock hackableBlock = HackManager.getHackableForBlock(this.hackedBlockPos.world, this.hackedBlockPos.pos, (Player)player);
            if (hackableBlock != null) {
                BlockGetter world = this.hackedBlockPos.world;
                int requiredTime = hackableBlock.getHackTime(world, this.hackedBlockPos.pos, (Player)player);
                if (requiredTime <= 0) {
                    this.setHackedBlockPos(null);
                    return;
                }
                if (++this.hackTime >= requiredTime) {
                    hackableBlock.onHackComplete(player.f_19853_, this.hackedBlockPos.pos, (Player)player);
                    HackTickTracker.getInstance(player.f_19853_).trackBlock(this.hackedBlockPos.pos, hackableBlock);
                    NetworkHandler.sendToAllTracking(new PacketHackingBlockFinish(this.hackedBlockPos), player.f_19853_, player.m_20183_());
                    this.setHackedBlockPos(null);
                    AdvancementTriggers.BLOCK_HACK.trigger(player);
                }
            } else {
                this.setHackedBlockPos(null);
            }
        }

        private void tickEntityHack(ServerPlayer player) {
            IHackableEntity<?> hackableEntity = HackManager.getHackableForEntity(this.hackedEntity, (Player)player);
            if (hackableEntity != null) {
                int requiredTime = hackableEntity._getHackTime(this.hackedEntity, (Player)player);
                if (requiredTime <= 0) {
                    this.setHackedEntity(null);
                    return;
                }
                if (++this.hackTime >= requiredTime) {
                    if (this.hackedEntity.m_6084_()) {
                        hackableEntity._onHackFinished(this.hackedEntity, (Player)player);
                        HackTickTracker.getInstance(player.f_19853_).trackEntity(this.hackedEntity, hackableEntity);
                        NetworkHandler.sendToAllTracking((Object)new PacketHackingEntityFinish(this.hackedEntity), this.hackedEntity);
                        AdvancementTriggers.ENTITY_HACK.trigger(player);
                    }
                    this.setHackedEntity(null);
                }
            } else {
                this.setHackedEntity(null);
            }
        }

        public void setHackedBlockPos(WorldAndCoord pos) {
            this.hackedBlockPos = pos;
            this.hackedEntity = null;
            this.hackTime = 0;
        }

        public void setHackedEntity(Entity entity) {
            this.hackedEntity = entity;
            this.hackedBlockPos = null;
            this.hackTime = 0;
        }
    }
}

