/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.RemoteItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateRemoteLayout {
    private final CompoundTag layout;
    private final InteractionHand hand;

    public PacketUpdateRemoteLayout(CompoundTag layout, InteractionHand hand) {
        this.layout = layout;
        this.hand = hand;
    }

    public PacketUpdateRemoteLayout(FriendlyByteBuf buffer) {
        this.layout = buffer.m_130260_();
        this.hand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.layout);
        buf.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack remote = ((NetworkEvent.Context)ctx.get()).getSender().m_21120_(this.hand);
            if (remote.m_41720_() instanceof RemoteItem) {
                CompoundTag tag = remote.m_41783_();
                if (tag == null) {
                    tag = new CompoundTag();
                    remote.m_41751_(tag);
                }
                tag.m_128365_("actionWidgets", (Tag)this.layout.m_128437_("actionWidgets", 10));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

