/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory.handler;

import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.world.item.ItemStack;

public class ChargeableItemHandler
extends BaseItemStackHandler {
    public ChargeableItemHandler(ChargingStationBlockEntity te) {
        super(te, 9);
        if (!NBTUtils.hasTag(this.getChargingStack(), "UpgradeInventory")) {
            this.writeToNBT();
        }
        this.readFromNBT();
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.writeToNBT();
    }

    private ItemStack getChargingStack() {
        return ((ChargingStationBlockEntity)this.te).getChargingStack();
    }

    public void writeToNBT() {
        UpgradableItemUtils.setUpgrades(this.getChargingStack(), this);
    }

    private void readFromNBT() {
        this.deserializeNBT(NBTUtils.getCompoundTag(this.getChargingStack(), "UpgradeInventory"));
    }

    public boolean isItemValid(int slot, ItemStack itemStack) {
        return itemStack.m_41619_() || this.isApplicable(itemStack) && this.isUnique(slot, itemStack);
    }

    private boolean isUnique(int slot, ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (i == slot || PNCUpgrade.from(stack) != PNCUpgrade.from(this.getStackInSlot(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isApplicable(ItemStack stack) {
        return ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.getChargingStack().m_41720_(), PNCUpgrade.from(stack)) > 0;
    }
}

