/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AreaTypeTorus
extends AreaType {
    public static final String ID = "torus";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.Y;
    private EnumTorusType torusType = EnumTorusType.FILLED;

    public AreaTypeTorus() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.torusType + "/" + this.axis;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                double radMajor = Math.round(PneumaticCraftUtils.distBetween(p1.m_123342_(), (double)p1.m_123343_(), (double)p2.m_123342_(), (double)p2.m_123343_()));
                double radMinor = Math.abs(p1.m_123341_() - p2.m_123341_());
                int RSq = (int)(radMajor * radMajor);
                int rSq = (int)(radMinor * radMinor);
                int rSqI = (int)((radMinor - 1.0) * (radMinor - 1.0));
                int pX = p1.m_123341_();
                int pY = p1.m_123342_();
                int pZ = p1.m_123343_();
                int apoX = (int)radMinor;
                int apoY = (int)(radMajor + radMinor);
                int apoZ = (int)(radMajor + radMinor);
                for (int y = -apoY; y <= apoY; ++y) {
                    for (int z = -apoZ; z <= apoZ; ++z) {
                        for (int x = -apoX; x <= apoX; ++x) {
                            int xSq = x * x;
                            int ySq = y * y;
                            int zSq = z * z;
                            if (this.torusType == EnumTorusType.FILLED) {
                                if ((xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (ySq + zSq)) continue;
                                areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                                continue;
                            }
                            if (this.torusType != EnumTorusType.HOLLOW || (xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (ySq + zSq) || (xSq + ySq + zSq + RSq - rSqI) * (xSq + ySq + zSq + RSq - rSqI) < 4 * RSq * (ySq + zSq)) continue;
                            areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                        }
                    }
                }
                break;
            }
            case Y: {
                double radMajor = Math.round(PneumaticCraftUtils.distBetween(p1.m_123341_(), (double)p1.m_123343_(), (double)p2.m_123341_(), (double)p2.m_123343_()));
                double radMinor = Math.abs(p1.m_123342_() - p2.m_123342_());
                int RSq = (int)(radMajor * radMajor);
                int rSq = (int)(radMinor * radMinor);
                int rSqI = (int)((radMinor - 1.0) * (radMinor - 1.0));
                int pX = p1.m_123341_();
                int pY = p1.m_123342_();
                int pZ = p1.m_123343_();
                int apoX = (int)(radMajor + radMinor);
                int apoY = (int)radMinor;
                int apoZ = (int)(radMajor + radMinor);
                for (int x = -apoX; x <= apoX; ++x) {
                    for (int z = -apoZ; z <= apoZ; ++z) {
                        for (int y = -apoY; y <= apoY; ++y) {
                            int xSq = x * x;
                            int ySq = y * y;
                            int zSq = z * z;
                            if (this.torusType == EnumTorusType.FILLED) {
                                if ((xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + zSq)) continue;
                                areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                                continue;
                            }
                            if (this.torusType != EnumTorusType.HOLLOW || (xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + zSq) || (xSq + ySq + zSq + RSq - rSqI) * (xSq + ySq + zSq + RSq - rSqI) < 4 * RSq * (xSq + zSq)) continue;
                            areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                        }
                    }
                }
                break;
            }
            case Z: {
                double radMajor = Math.round(PneumaticCraftUtils.distBetween(p1.m_123341_(), (double)p1.m_123342_(), (double)p2.m_123341_(), (double)p2.m_123342_()));
                double radMinor = Math.abs(p1.m_123343_() - p2.m_123343_());
                int RSq = (int)(radMajor * radMajor);
                int rSq = (int)(radMinor * radMinor);
                int rSqI = (int)((radMinor - 1.0) * (radMinor - 1.0));
                int pX = p1.m_123341_();
                int pY = p1.m_123342_();
                int pZ = p1.m_123343_();
                int apoX = (int)(radMajor + radMinor);
                int apoY = (int)(radMajor + radMinor);
                int apoZ = (int)radMinor;
                for (int x = -apoX; x <= apoX; ++x) {
                    for (int y = -apoY; y <= apoY; ++y) {
                        for (int z = -apoZ; z <= apoZ; ++z) {
                            int xSq = x * x;
                            int ySq = y * y;
                            int zSq = z * z;
                            if (this.torusType == EnumTorusType.FILLED) {
                                if ((xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + ySq)) continue;
                                areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                                continue;
                            }
                            if (this.torusType != EnumTorusType.HOLLOW || (xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + ySq) || (xSq + ySq + zSq + RSq - rSqI) * (xSq + ySq + zSq + RSq - rSqI) < 4 * RSq * (xSq + ySq)) continue;
                            areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumTorusType>("pneumaticcraft.gui.progWidget.area.type.torus.torusType", EnumTorusType.class, () -> this.torusType, torusType -> {
            this.torusType = torusType;
        }));
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("axis", (byte)this.axis.ordinal());
        tag.m_128344_("torusType", (byte)this.torusType.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.m_128445_("axis")];
        this.torusType = EnumTorusType.values()[tag.m_128445_("torusType")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.axis.ordinal());
        buffer.writeByte(this.torusType.ordinal());
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axis = AreaType.EnumAxis.values()[buf.readByte()];
        this.torusType = EnumTorusType.values()[buf.readByte()];
    }

    private static enum EnumTorusType {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private EnumTorusType(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.torus.torusType." + name;
        }

        public String toString() {
            return I18n.m_118938_((String)this.name, (Object[])new Object[0]);
        }
    }
}

