/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.debug;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.debug.DroneDebugEntry;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class DroneDebugger {
    private final IDroneBase drone;
    private final DroneDebugList debugList = new DroneDebugList();
    private final Set<ServerPlayer> debuggingPlayers = new HashSet<ServerPlayer>();

    public DroneDebugger(IDroneBase drone) {
        this.drone = drone;
    }

    public DroneDebugEntry getDebugEntry(int widgetID) {
        return this.debugList.get(widgetID);
    }

    public void addEntry(String message) {
        this.addEntry(message, null);
    }

    public void addEntry(String message, BlockPos pos) {
        DroneDebugEntry entry = new DroneDebugEntry(message, this.getActiveWidgetIndex(), pos);
        this.addEntry(entry);
        PacketSendDroneDebugEntry packet = new PacketSendDroneDebugEntry(entry, this.drone);
        for (ServerPlayer player : this.debuggingPlayers) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    public void addEntry(DroneDebugEntry entry) {
        this.debugList.addEntry(entry);
    }

    public void trackAsDebugged(ServerPlayer player) {
        NetworkHandler.sendToPlayer(new PacketSyncDroneEntityProgWidgets(this.drone), player);
        for (DroneDebugEntry entry : this.debugList.getAll()) {
            NetworkHandler.sendToPlayer(new PacketSendDroneDebugEntry(entry, this.drone), player);
        }
        this.debuggingPlayers.add(player);
    }

    public void updateDebuggingPlayers() {
        this.debuggingPlayers.removeIf(player -> !player.m_6084_() || !PneumaticArmorItem.isPlayerDebuggingDrone((Player)player, this.drone));
    }

    public Collection<ServerPlayer> getDebuggingPlayers() {
        return this.debuggingPlayers;
    }

    private int getActiveWidgetIndex() {
        return this.drone.getActiveWidgetIndex();
    }

    private class DroneDebugList {
        private final Map<Integer, DroneDebugEntry> debugEntries = new HashMap<Integer, DroneDebugEntry>();

        private DroneDebugList() {
        }

        void addEntry(DroneDebugEntry entry) {
            this.debugEntries.put(DroneDebugger.this.getActiveWidgetIndex(), entry);
        }

        public Collection<DroneDebugEntry> getAll() {
            return this.debugEntries.values();
        }

        public DroneDebugEntry get(int widgetId) {
            return this.debugEntries.get(widgetId);
        }

        public DroneDebugEntry getCurrent() {
            return this.debugEntries.get(DroneDebugger.this.getActiveWidgetIndex());
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLivingUpdateEvent(LivingEvent.LivingTickEvent event) {
            Path path;
            DroneEntity drone;
            block8: {
                block7: {
                    LivingEntity livingEntity;
                    if (!((Boolean)ConfigHelper.common().drones.droneDebuggerPathParticles.get()).booleanValue() || !((livingEntity = event.getEntity()) instanceof DroneEntity)) break block7;
                    drone = (DroneEntity)livingEntity;
                    if (!event.getEntity().f_19853_.f_46443_) break block8;
                }
                return;
            }
            if (drone.getDebugger().debuggingPlayers.isEmpty()) {
                return;
            }
            PathNavigation navi = drone.m_21573_();
            if (drone.f_19853_ instanceof ServerLevel && drone.f_19853_.m_46467_() % 10L == 0L && (path = navi.m_26570_()) != null) {
                for (int i = path.m_77399_(); i < path.m_77398_(); ++i) {
                    BlockPos pos = path.m_77375_(i).m_77288_();
                    BlockPos nextPos = i + 1 != path.m_77398_() ? path.m_77375_(i + 1).m_77288_() : pos;
                    BlockPos endPos = nextPos.m_121996_((Vec3i)pos);
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.f_123810_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, endPos.m_123341_(), endPos.m_123342_(), endPos.m_123343_(), 0.1);
                }
                BlockPos pos = navi.m_26567_();
                if (pos != null && drone.getDronePos().m_82557_(Vec3.m_82512_((Vec3i)pos)) > 1.0) {
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.f_123750_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        private static <T extends ParticleOptions> void spawnParticle(Set<ServerPlayer> players, T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
            ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(type, false, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
            players.forEach(player -> player.f_8906_.m_9829_((Packet)packet));
        }
    }
}

