/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.google.common.base.Strings;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.AirConditionerOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.AirConHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class AirConClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler<AirConHandler> {
    private static final int MAX_AC = 20;
    private static final StatPanelLayout DEFAULT_STAT_LAYOUT = new StatPanelLayout(0.5f, 0.005f, false);
    public static int deltaTemp;
    private static int currentAC;
    private IGuiAnimatedStat acStat;

    public AirConClientHandler() {
        super(CommonUpgradeHandlers.airConHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new AirConditionerOptions(screen, this);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        super.tickClient(armorHandler);
        if ((armorHandler.getPlayer().f_19853_.m_46467_() & 3L) == 0L) {
            if (currentAC < deltaTemp) {
                ++currentAC;
            } else if (currentAC > deltaTemp) {
                --currentAC;
            }
        }
        if (this.acStat.isStatOpen()) {
            int ac = Mth.m_14045_((int)currentAC, (int)-20, (int)20);
            String bar = (ac < 0 ? ChatFormatting.BLUE : ChatFormatting.GOLD) + Strings.repeat((String)"|", (int)Math.abs(ac)) + ChatFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(20 - Math.abs(ac)));
            this.acStat.setTitle((Component)Component.m_237113_((String)("A/C: " + bar)).m_130940_(ChatFormatting.YELLOW));
            this.acStat.setBackgroundColor(ac < 0 ? 805339391 : (ac == 0 ? 0x3000AA00 : 822071296));
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.acStat == null) {
            this.acStat = ClientArmorRegistry.getInstance().makeHUDStatPanel((Component)Component.m_237119_(), ItemStack.f_41583_, this);
            this.acStat.setMinimumContractedDimensions(0, 0);
        }
        return this.acStat;
    }

    @Override
    public StatPanelLayout getDefaultStatLayout() {
        return DEFAULT_STAT_LAYOUT;
    }

    @Override
    public void onResolutionChanged() {
        this.acStat = null;
    }

    static {
        currentAC = 0;
    }
}

