/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class BlockPlatformSteps
extends BlockPlatformType.Inclines {
    public BlockPlatformSteps() {
        super(EnumPlatformType.STEPS);
    }

    @Override
    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            VoxelShape[] parts = new VoxelShape[2];
            String base = subType.getBaseType() == EnumSubType.EnumBase.NORMAL ? "normal" : subType.getStyleName();
            parts[0] = (VoxelShape)HITBOXES.get((Object)("steps_" + base + (collision ? "_collide" : "_select")), (Object)direction);
            if (railType != null) {
                parts[1] = this.getRailingBox(subType.getStyleType(), railType, collision, direction);
            }
            return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
        }
        return null;
    }

    @Override
    protected void updateBlock(TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos) {
        TileHelper.setAltSupport((BlockEntity)tile, this.getSupports(world, pos));
        Function.syncTile((BlockEntity)tile);
    }

    static {
        BlockPlatformSteps.addHitBoxData("steps_normal_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 8.0, 16.0}, {0.0, 8.0, 0.0, 16.0, 16.0, 8.0}});
        BlockPlatformSteps.addHitBoxData("steps_normal_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 8.0, 16.0}, {0.0, 8.0, 0.0, 16.0, 16.0, 8.0}});
        BlockPlatformSteps.addHitBoxData("steps_inside_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 8.0, 16.0}, {0.0, 8.0, 0.0, 16.0, 16.0, 8.0}, {8.0, 8.0, 8.0, 16.0, 16.0, 16.0}});
        BlockPlatformSteps.addHitBoxData("steps_inside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 8.0, 16.0}, {0.0, 8.0, 0.0, 16.0, 16.0, 8.0}, {8.0, 8.0, 8.0, 16.0, 16.0, 16.0}});
        BlockPlatformSteps.addHitBoxData("steps_outside_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 8.0, 16.0}, {8.0, 8.0, 0.0, 16.0, 16.0, 8.0}});
        BlockPlatformSteps.addHitBoxData("steps_outside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 8.0, 16.0}, {8.0, 8.0, 0.0, 16.0, 16.0, 8.0}});
    }
}

